/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;

public class NetUtilsTest {
    @Test
    public void testEphemeralPort() {
        Assert.assertTrue((NetUtils.getEphemeralPort() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOwnHostname() {
        String host = NetUtils.getOwnHostname();
        Assert.assertNotNull((Object)host);
        Assert.assertTrue((host.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIsAvailable() {
        int trials;
        String host = "localhost";
        int port = NetUtils.getEphemeralPort();
        Assert.assertFalse((boolean)NetUtils.isAvailable((String)host, (int)port));
        port = NetUtils.getEphemeralPort();
        ServerRunnable sr = new ServerRunnable(port);
        new Thread(sr).start();
        for (trials = 0; !NetUtils.isAvailable((String)host, (int)port) && trials < 10; ++trials) {
            TimeUtils.sleep((int)500);
        }
        Assert.assertTrue((trials < 10 ? 1 : 0) != 0);
        sr.stop();
    }

    @Test
    public void testIsOwnAddress() {
        Assert.assertTrue((boolean)NetUtils.isOwnAddress((String)"localhost"));
        Assert.assertTrue((boolean)NetUtils.isOwnAddress((String)"127.0.0.1"));
        Assert.assertFalse((boolean)NetUtils.isOwnAddress((String)"192.168.2.255"));
    }

    @Test
    public void isInContainer() {
        System.out.println("In container: " + NetUtils.isInContainer());
    }

    @Test
    public void testCreateUrl() {
        try {
            NetUtils.createURL((String)"");
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String text = "https://oktoflow.de";
        URL url = NetUtils.createURL((String)"https://oktoflow.de");
        Assert.assertEquals((Object)"https://oktoflow.de", (Object)url.toString());
    }

    @Test
    public void testGetOwnIP() {
        String ip = NetUtils.getOwnIP();
        Assert.assertTrue((ip.length() > 0 ? 1 : 0) != 0);
        NetUtils.isContainerIp((String)ip);
        NetUtils.isIpV4Addess((String)ip);
        NetUtils.getNetMask((String)"255.255.255.0", (String)ip);
        NetUtils.connectionOk((String)"http://localhost");
        NetUtils.getOwnIP(null);
        NetUtils.getOwnIP((String)"");
        NetUtils.getOwnIP((String)"255.255.255.0");
        NetUtils.findFallbackIP();
    }

    private class ServerRunnable
    implements Runnable {
        private int port;
        private boolean running = true;

        private ServerRunnable(int port) {
            this.port = port;
        }

        @Override
        public void run() {
            try (ServerSocket serverSocket = new ServerSocket(this.port);){
                System.out.println("Server is listening on port " + this.port);
                while (this.running) {
                    Socket socket = serverSocket.accept();
                    System.out.println("New client connected");
                    socket.close();
                }
            }
            catch (IOException ex) {
                System.out.println("Server exception: " + ex.getMessage());
            }
        }

        private void stop() {
            this.running = false;
        }
    }
}

