/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.commons.Commons;
import de.iip_ecosphere.platform.support.resources.FolderResourceResolver;
import de.iip_ecosphere.platform.support.resources.MavenResourceResolver;
import de.iip_ecosphere.platform.support.resources.MultiResourceResolver;
import de.iip_ecosphere.platform.support.resources.OktoflowResourceResolver;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.support.ServiceLoaderUtilsDescriptor;

public class ResourceLoaderTest {
    private static int myResolverCalled = 0;
    private static int myResolver2Called = 0;

    @Test
    public void testResolver() throws IOException {
        myResolverCalled = 0;
        myResolver2Called = 0;
        MyResolver2 res = new MyResolver2();
        Assert.assertFalse((boolean)ResourceLoader.knowsResourceResolver((ResourceResolver)res));
        ResourceLoader.registerResourceResolver((ResourceResolver)res);
        Assert.assertTrue((boolean)ResourceLoader.knowsResourceResolver((ResourceResolver)res));
        InputStream is = ResourceLoader.getResourceAsStream((String)"Logo.jpg", (ResourceResolver[])new ResourceResolver[0]);
        Assert.assertNotNull((Object)is);
        is = ResourceLoader.getResourceAsStream((String)"/Logo.jpg", (ResourceResolver[])new ResourceResolver[0]);
        Assert.assertNotNull((Object)is);
        is.close();
        Assert.assertTrue((myResolverCalled == 0 ? 1 : 0) != 0);
        Assert.assertTrue((myResolver2Called == 0 ? 1 : 0) != 0);
        is = ResourceLoader.getResourceAsStream((String)"BadBadFile.xyz", (ResourceResolver[])new ResourceResolver[0]);
        Assert.assertNull((Object)is);
        Assert.assertTrue((myResolverCalled > 0 ? 1 : 0) != 0);
        Assert.assertTrue((myResolver2Called > 0 ? 1 : 0) != 0);
        is = ResourceLoader.getAllRegisteredResolver((ResourceResolver[])new ResourceResolver[0]).resolve("Logo.jpg");
        Assert.assertNotNull((Object)is);
        is.close();
        new FolderResourceResolver();
        FolderResourceResolver fRes = new FolderResourceResolver("./src/test/resources/META-INF/services");
        ResourceResolver myResolver = ResourceLoader.getAllRegisteredResolver((ResourceResolver[])new ResourceResolver[]{fRes});
        is = myResolver.resolve("Logo.jpg");
        Assert.assertNotNull((Object)is);
        is.close();
        is = myResolver.resolve("de.iip_ecosphere.platform.support.resources.ResourceResolver");
        Assert.assertNotNull((Object)is);
        is.close();
        is = ResourceLoader.getResourceAsStream((String)"de.iip_ecosphere.platform.support.resources.ResourceResolver", (ResourceResolver[])new ResourceResolver[]{fRes});
        Assert.assertNotNull((Object)is);
        is.close();
        ResourceLoader.unregisterResourceResolver((ResourceResolver)res);
        is = ResourceLoader.MAVEN_RESOLVER.resolve("Logo.jpg");
        Assert.assertNotNull((Object)is);
        is.close();
        Assert.assertFalse((boolean)ResourceLoader.hasFilters());
        ResourceLoader.addTestExcludeFilters();
        Assert.assertTrue((boolean)ResourceLoader.hasFilters());
        is = ResourceLoader.MAVEN_RESOLVER.resolve("Logo.jpg");
        Assert.assertNotNull((Object)is);
        is.close();
        ResourceLoader.addFilter(f -> !f.toString().contains("/services/"));
        is = ResourceLoader.getResourceAsStream((String)("META-INF/services/" + ServiceLoaderUtilsDescriptor.class.getName()), (ResourceResolver[])new ResourceResolver[0]);
        Assert.assertNull((Object)is);
        ResourceLoader.clearFilters();
        Assert.assertFalse((boolean)ResourceLoader.hasFilters());
    }

    @Test
    public void testPrependSlash() {
        Assert.assertEquals((Object)"/a", (Object)ResourceLoader.prependSlash((String)"a"));
        Assert.assertEquals((Object)"/a", (Object)ResourceLoader.prependSlash((String)"/a"));
        Assert.assertEquals((Object)"/", (Object)ResourceLoader.prependSlash((String)""));
    }

    @Test
    public void testOktoflowResourceResolver() throws IOException {
        new OktoflowResourceResolver();
        OktoflowResourceResolver res = new OktoflowResourceResolver(new File("src/test/resources/okto1"));
        InputStream in = ResourceLoader.getResourceAsStream((String)"nameplate.txt", (ResourceResolver[])new ResourceResolver[]{res});
        Assert.assertNotNull((Object)in);
        String txt = Commons.getInstance().toString(in, Charset.defaultCharset());
        Assert.assertEquals((Object)"resources", (Object)txt);
        in.close();
        res = new OktoflowResourceResolver(new File("src/test/resources/okto2"));
        in = ResourceLoader.getResourceAsStream((String)"nameplate.txt", (ResourceResolver[])new ResourceResolver[]{res});
        Assert.assertNotNull((Object)in);
        txt = Commons.getInstance().toString(in, Charset.defaultCharset());
        Assert.assertEquals((Object)"resources.ipr", (Object)txt);
        in.close();
        res = new OktoflowResourceResolver(new File("src/test/resources/okto3"), "software");
        in = ResourceLoader.getResourceAsStream(ResourceLoaderTest.class, (String)"nameplate.txt", (ResourceResolver[])new ResourceResolver[]{res});
        Assert.assertNotNull((Object)in);
        txt = Commons.getInstance().toString(in, Charset.defaultCharset());
        Assert.assertEquals((Object)"resources.ipr", (Object)txt);
        in.close();
    }

    @Test
    public void testResolvers() throws IOException {
        Assert.assertTrue((MultiResourceResolver.SETUP_RESOLVER.getName().length() > 0 ? 1 : 0) != 0);
        MavenResourceResolver mRes = new MavenResourceResolver(new File("src/test/resources/okto3"));
        Assert.assertTrue((mRes.getName().length() > 0 ? 1 : 0) != 0);
        InputStream in = mRes.resolve("nameplate.res");
        Assert.assertNotNull((Object)in);
        in.close();
        FolderResourceResolver fRes = new FolderResourceResolver(new File("src/test/resources/okto3"), "prefix_");
        Assert.assertTrue((fRes.getName().length() > 0 ? 1 : 0) != 0);
        in = fRes.resolve("prefix_nameplate.test");
        Assert.assertNotNull((Object)in);
        in.close();
    }

    public static class MyResolver2
    implements ResourceResolver {
        public InputStream resolve(ClassLoader loader, String resource) {
            myResolver2Called++;
            return null;
        }
    }

    public static class MyResolver
    implements ResourceResolver {
        public InputStream resolve(ClassLoader loader, String resource) {
            myResolverCalled++;
            return null;
        }
    }
}

