/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.StringUtils;
import java.util.StringTokenizer;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    @Test
    public void testIsEmptyBlank() {
        Assert.assertTrue((boolean)StringUtils.isBlank(null));
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)"   "));
        Assert.assertFalse((boolean)StringUtils.isBlank((CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.isEmpty(null));
        Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)"   "));
        Assert.assertFalse((boolean)StringUtils.isEmpty((CharSequence)"a"));
    }

    @Test
    public void testToString() {
        TestData t = new TestData();
        t.iVal = 10;
        t.sVal = "abc";
        StringUtils.toStringShortStyle((Object)t);
    }

    @Test
    public void testTokens() {
        Assert.assertEquals((Object)CollectionUtils.toList((Object[])new String[]{"a", "b"}), (Object)StringUtils.toTokenList((StringTokenizer)new StringTokenizer("a, b", ", ")));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])StringUtils.toTokenArray((StringTokenizer)new StringTokenizer("a, b", ", ")));
        Assert.assertNull((Object)StringUtils.toArray(null));
    }

    @Test
    public void testRest() {
        StringUtils.unescapeJava((String)StringUtils.escapeJava((String)"\n"));
        StringUtils.unescapeJson((String)StringUtils.escapeJson((String)"\t"));
        StringUtils.removeEnd((String)"ThisEnd", (String)"End");
        StringUtils.removeStart((String)"ThisEnd", (String)"This");
        StringUtils.defaultIfBlank(null, (CharSequence)"a");
        StringUtils.defaultIfBlank((CharSequence)"", (CharSequence)"a");
        StringUtils.defaultIfBlank((CharSequence)"   ", (CharSequence)"a");
        StringUtils.defaultIfEmpty(null, (CharSequence)"a");
        StringUtils.defaultIfEmpty((CharSequence)"", (CharSequence)"a");
        StringUtils.defaultIfEmpty((CharSequence)"   ", (CharSequence)"a");
        StringUtils.isNotBlank((CharSequence)"   ");
        StringUtils.replaceOnce((String)"", (String)"", (String)"");
        StringUtils.toString((Object)new Object());
    }

    private static class TestData {
        private int iVal;
        private String sVal;

        private TestData() {
        }
    }
}

