/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.support.yaml.YamlFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class YamlFileTest {
    @Test
    public void testYamlFile() throws IOException {
        YamlFile.read((InputStream)ResourceLoader.getResourceAsStream((String)"nameplate.yml", (ResourceResolver[])new ResourceResolver[0]));
    }

    @Test
    public void testYamlFileSpring() throws IOException {
        Object data = YamlFile.read((InputStream)ResourceLoader.getResourceAsStream((String)"YamlFile.yml", (ResourceResolver[])new ResourceResolver[0]));
        String bindingsPath = "spring.cloud.stream.bindings";
        String[] bindingsFieldPath = "spring.cloud.stream.bindings".split("\\.");
        YamlFile.getFieldAsMap((Object)data, (String[])bindingsFieldPath);
        Assert.assertEquals((Object)"a", (Object)YamlFile.asString(null, (String)"a"));
        Assert.assertEquals((Object)"1", (Object)YamlFile.asString((Object)1, (String)"a"));
        Assert.assertNotNull((Object)YamlFile.asList(null));
        ArrayList testList = new ArrayList();
        Assert.assertTrue((testList == YamlFile.asList(testList) ? 1 : 0) != 0);
        new YamlFileExtended();
        YamlFile.getFieldAsString((Object)data, (String)"spring.cloud.stream.bindings", (String)"spring.cloud.stream.bindings");
        YamlFile.getFieldAsList((Object)data, (String)"spring.cloud.stream.bindings");
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("a", Integer.valueOf(1));
        HashMap<String, Object> bMap = new HashMap<String, Object>();
        bMap.put("b1", "abc");
        bMap.put("b2", new HashMap());
        map.put("b", bMap);
        YamlFile.overwrite(map, Object.class, map);
    }

    @Test
    public void testFixList() {
        Assert.assertNull((Object)YamlFile.fixListSafe(null, TestType.class));
        List list = new ArrayList();
        Assert.assertEquals(list, (Object)YamlFile.fixListSafe(list, TestType.class));
        HashMap<String, Integer> oMap = new HashMap<String, Integer>();
        oMap.put("iValue", 10);
        ArrayList<HashMap<String, Integer>> oList = new ArrayList<HashMap<String, Integer>>();
        oList.add(oMap);
        list = oList;
        list = YamlFile.fixListSafe(list, TestType.class);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof TestType));
        Assert.assertEquals((long)10L, (long)((TestType)list.get(0)).getIValue());
    }

    @Test
    public void testGetMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("key", 1);
        HashMap<String, HashMap<String, Integer>> map2 = new HashMap<String, HashMap<String, Integer>>();
        map2.put("obj", map);
        HashMap<String, HashMap<String, HashMap<String, Integer>>> map3 = new HashMap<String, HashMap<String, HashMap<String, Integer>>>();
        map3.put("obj", map2);
        Assert.assertNull((Object)YamlFile.getMap(map3, (String[])new String[0]));
        Assert.assertNull((Object)YamlFile.getMap(map3, (String[])new String[]{"test"}));
        Assert.assertNotNull((Object)YamlFile.getMap(map3, (String[])new String[]{"obj"}));
        Assert.assertNotNull((Object)YamlFile.getMap(map3, (String[])new String[]{"obj", "obj"}));
        Assert.assertNotNull((Object)YamlFile.getMap(map3, (String[])new String[]{"obj", "obj", "key"}));
    }

    private static class YamlFileExtended
    extends YamlFile {
        private YamlFileExtended() {
        }
    }

    public static class TestType
    extends BasicTestType {
    }

    public static class ExtendedTestType
    extends BasicTestType {
        private BasicTestType nested;

        public BasicTestType getNested() {
            return this.nested;
        }

        public void setNested(BasicTestType nested) {
            this.nested = nested;
        }
    }

    public static class BasicTestType {
        private int iValue;

        public int getIValue() {
            return this.iValue;
        }

        public void setIValue(int iValue) {
            this.iValue = iValue;
        }
    }
}

