/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.json;

import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;

public class JsonResultWrapperTest {
    @Test
    public void testWrapperBasic() throws ExecutionException {
        JsonResultWrapper w = new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> true);
        JsonResultWrapper.Result res = JsonResultWrapper.resultFromJson((Object)w.apply(null));
        Assert.assertNotNull((Object)res);
        Assert.assertNull((Object)res.getException());
        Assert.assertEquals((Object)true, (Object)Boolean.valueOf(res.getResult()));
        JsonResultWrapper.fromJson((Object)w.apply(null));
        w = new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            throw new ExecutionException("exc", null);
        });
        res = JsonResultWrapper.resultFromJson((Object)w.apply(null));
        Assert.assertNotNull((Object)res);
        Assert.assertNull((Object)res.getResult());
        Assert.assertNotNull((Object)res.getException());
        Assert.assertEquals((Object)"exc", (Object)res.getException());
        try {
            JsonResultWrapper.fromJson((Object)w.apply(null));
            Assert.fail((String)"No exception");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        Assert.assertNull((Object)JsonResultWrapper.fromJson(null));
        res = JsonResultWrapper.resultFromJson((Object)"");
        Assert.assertNotNull((Object)res);
        Assert.assertNotNull((Object)res.getException());
        Assert.assertTrue((res.getException().length() > 0 ? 1 : 0) != 0);
        JsonResultWrapper.fromJson((Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> true), (Object[])new Object[]{1});
    }

    @Test
    public void testWrapperListener() throws ExecutionException {
        final AtomicInteger completedCount = new AtomicInteger();
        final AtomicInteger failedCount = new AtomicInteger();
        JsonResultWrapper.OperationCompletedListener listener = new JsonResultWrapper.OperationCompletedListener(){

            public void operationCompleted() {
                completedCount.incrementAndGet();
            }

            public void operationFailed() {
                failedCount.incrementAndGet();
            }
        };
        JsonResultWrapper w = new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> true, listener);
        JsonResultWrapper.resultFromJson((Object)w.apply(null));
        Assert.assertEquals((long)1L, (long)completedCount.getAndSet(0));
        Assert.assertEquals((long)0L, (long)failedCount.getAndSet(0));
        w = new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            throw new ExecutionException("exc", null);
        }, listener);
        JsonResultWrapper.resultFromJson((Object)w.apply(null));
        Assert.assertEquals((long)0L, (long)completedCount.getAndSet(0));
        Assert.assertEquals((long)1L, (long)failedCount.getAndSet(0));
    }

    @Test
    public void testWrapperTask() throws ExecutionException {
        JsonResultWrapper w = new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> true, p -> "t123");
        JsonResultWrapper.resultFromJson((Object)w.apply(null));
        w = new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            throw new ExecutionException("exc", null);
        }, p -> "t124");
        JsonResultWrapper.resultFromJson((Object)w.apply(null));
    }
}

