/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.JavaBinaryPathDescriptor;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import java.io.File;
import java.util.Optional;
import java.util.function.Supplier;

public class JavaUtils {
    private static Supplier<String> binaryPathSupplier;

    public static String getJavaBinaryPath(String dflt) {
        String result = JavaUtils.getJavaBinaryPath();
        if (null == result) {
            result = dflt;
        }
        return result;
    }

    public static String getJavaBinaryPath() {
        if (null == binaryPathSupplier) {
            Optional<JavaBinaryPathDescriptor> desc = ServiceLoaderUtils.findFirst(JavaBinaryPathDescriptor.class);
            binaryPathSupplier = desc.isPresent() ? desc.get().createSupplier() : () -> null;
        }
        return binaryPathSupplier.get();
    }

    public static String getJavaPath() {
        String javaPath = JavaUtils.getJavaBinaryPath();
        if (null != javaPath) {
            int pos = javaPath.lastIndexOf(File.separator);
            if (pos > 0) {
                javaPath = javaPath.substring(0, pos);
            }
        } else {
            int pos;
            javaPath = System.getProperty("sun.boot.library.path");
            if (null != javaPath && (pos = javaPath.lastIndexOf(File.separator + "lib")) > 0) {
                javaPath = javaPath.substring(0, pos) + File.separator + "bin";
            }
        }
        return javaPath;
    }
}

