/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.DelegatingInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class DelegatingInputStreamTest {
    @Test
    public void testStream() throws IOException {
        FileInputStream fis = new FileInputStream("src/test/resources/YamlFile.yml");
        MyDelegatingInputStream dis = new MyDelegatingInputStream(new FileInputStream("src/test/resources/YamlFile.yml"));
        Assert.assertEquals((long)((InputStream)fis).available(), (long)dis.available());
        Assert.assertEquals((Object)fis.markSupported(), (Object)dis.markSupported());
        Assert.assertEquals((long)((InputStream)fis).read(), (long)dis.read());
        Assert.assertEquals((long)((InputStream)fis).skip(2L), (long)dis.skip(2L));
        byte[] fisBuf = new byte[10];
        byte[] disBuf = new byte[10];
        ((InputStream)fis).read(fisBuf);
        dis.read(disBuf);
        Assert.assertArrayEquals((byte[])fisBuf, (byte[])disBuf);
        ((InputStream)fis).read(fisBuf, 0, 1);
        dis.read(disBuf, 0, 1);
        Assert.assertEquals((long)fisBuf[0], (long)disBuf[0]);
        fis.mark(10);
        dis.mark(10);
        try {
            fis.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            dis.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)dis.getDel());
        dis.close();
        ((InputStream)fis).close();
    }

    private class MyDelegatingInputStream
    extends DelegatingInputStream {
        public MyDelegatingInputStream(InputStream delegate) {
            super(delegate);
        }

        public InputStream getDel() {
            return this.getDelegate();
        }
    }
}

