/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.JavaUtils;
import de.iip_ecosphere.platform.support.plugins.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.support.Main;

public class StreamGobblerTest {
    @Test
    public void testGobbler() throws IOException {
        Process proc = this.createProcess();
        StreamGobbler.attach((Process)proc);
        this.waitFor(proc);
    }

    @Test
    public void testConsumingGobbler() throws IOException {
        AtomicInteger count = new AtomicInteger();
        Consumer<String> cons = l -> count.incrementAndGet();
        Process proc = this.createProcess();
        StreamGobbler.attach((Process)proc, cons, cons);
        this.waitFor(proc);
        Assert.assertTrue((count.get() > 1 ? 1 : 0) != 0);
    }

    private Process createProcess() throws IOException {
        String javaPath = JavaUtils.getJavaPath();
        Process proc = new ProcessBuilder(javaPath + "/java", "-cp", "target/test-classes" + File.pathSeparator + "target/classes", Main.class.getName(), "3").start();
        return proc;
    }

    private void waitFor(Process proc) {
        try {
            proc.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

