/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.logging;

import de.iip_ecosphere.platform.support.logging.FallbackLogger;
import de.iip_ecosphere.platform.support.logging.ILoggerFactory;
import de.iip_ecosphere.platform.support.logging.LogLevel;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.PluginDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.plugins.SingletonPluginDescriptor;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class LoggerFactoryTest {
    @Test
    public void testSetLoggerFactory() {
        LoggerFactory.setLoggerFactory((ILoggerFactory)LoggerFactory.getLoggerFactory());
    }

    @Test
    public void testFactory() {
        Logger l1;
        Logger l = LoggerFactory.getLogger(this.getClass());
        Assert.assertTrue((l == (l1 = LoggerFactory.getLogger((Object)this)) ? 1 : 0) != 0);
        l1 = LoggerFactory.getLogger(this.getClass());
        Assert.assertTrue((l == l1 ? 1 : 0) != 0);
        l1 = LoggerFactory.getLogger(LoggerFactoryTest.class);
        Assert.assertTrue((l == l1 ? 1 : 0) != 0);
        l1 = LoggerFactory.getLogger((String)LoggerFactoryTest.class.getName());
        Assert.assertTrue((l == l1 ? 1 : 0) != 0);
    }

    @Test
    public void testAll() {
        this.log(LogLevel.ALL);
    }

    @Test
    public void testTrace() {
        this.log(LogLevel.ERROR);
    }

    @Test
    public void testOff() {
        this.log(LogLevel.OFF);
    }

    private void log(LogLevel level) {
        Throwable t = new Throwable("JUST A TEST THROWABLE, DO NOT WORRY");
        Logger l = LoggerFactory.getLogger((Object)this);
        l.setLevel(level);
        System.out.println("> Log level " + level);
        l.error("ERROR-MSG");
        l.error("ERROR-MSG {}", (Object)1);
        l.error("ERROR-MSG {} {}", (Object)1, (Object)2);
        l.error("ERROR-MSG {} {}, {}", new Object[]{1, 2, null});
        l.error("ERROR-MSG", t);
        l.log(LogLevel.ERROR, "ERROR-MSG");
        l.log(LogLevel.ERROR, "ERROR-MSG {}", (Object)1);
        l.log(LogLevel.ERROR, "ERROR-MSG {} {}", (Object)1, (Object)2);
        l.log(LogLevel.ERROR, "ERROR-MSG {} {}, {}", new Object[]{1, 2, null});
        l.log(LogLevel.ERROR, "ERROR-MSG", t);
        l.warn("WARN-MSG");
        l.warn("WARN-MSG {}", (Object)1);
        l.warn("WARN-MSG {} {}", (Object)1, (Object)2);
        l.warn("WARN-MSG {} {}, {}", new Object[]{1, 2, "three"});
        l.warn("WARN-MSG", t);
        l.log(LogLevel.WARN, "WARN-MSG");
        l.log(LogLevel.WARN, "WARN-MSG {}", (Object)1);
        l.log(LogLevel.WARN, "WARN-MSG {} {}", (Object)1, (Object)2);
        l.log(LogLevel.WARN, "WARN-MSG {} {}, {}", new Object[]{1, 2, "three"});
        l.log(LogLevel.WARN, "WARN-MSG", t);
        l.info("INFO-MSG");
        l.info("INFO-MSG {}", (Object)1);
        l.info("INFO-MSG {} {}", (Object)1, (Object)2);
        l.info("INFO-MSG {} {}, {}", new Object[]{1, 2, "three"});
        l.info("INFO-MSG", t);
        l.log(LogLevel.INFO, "INFO-MSG");
        l.log(LogLevel.INFO, "INFO-MSG {}", (Object)1);
        l.log(LogLevel.INFO, "INFO-MSG {} {}", (Object)1, (Object)new int[]{2});
        l.log(LogLevel.INFO, "INFO-MSG {} {}, {}", new Object[]{1, 2, "three"});
        l.log(LogLevel.INFO, "INFO-MSG", t);
        l.debug("INFO-DEBUG");
        l.debug("INFO-DEBUG {}", (Object)1);
        l.debug("INFO-DEBUG {} {}", (Object)1, (Object)2);
        l.debug("INFO-DEBUG {} {}, {}", new Object[]{1, 2, "three"});
        l.debug("INFO-DEBUG", t);
        l.log(LogLevel.DEBUG, "INFO-DEBUG");
        l.log(LogLevel.DEBUG, "INFO-DEBUG {}", (Object)1);
        l.log(LogLevel.DEBUG, "INFO-DEBUG {} {}", (Object)1, (Object)2);
        l.log(LogLevel.DEBUG, "INFO-DEBUG {} {}, {}", new Object[]{1, 2, "three"});
        l.log(LogLevel.DEBUG, "INFO-DEBUG", t);
        l.trace("INFO-TRACE");
        l.trace("INFO-TRACE {}", (Object)1);
        l.trace("INFO-TRACE {} {}", (Object)1, (Object)2);
        l.trace("INFO-TRACE {} {}, {}", new Object[]{1, 2, "three"});
        l.trace("INFO-TRACE", t);
        l.log(LogLevel.TRACE, "INFO-TRACE");
        l.log(LogLevel.TRACE, "INFO-TRACE {}", (Object)1);
        l.log(LogLevel.TRACE, "INFO-TRACE {} {}", (Object)1, (Object)2);
        l.log(LogLevel.TRACE, "INFO-TRACE {} {}, {}", new Object[]{1, 2, "three"});
        l.log(LogLevel.TRACE, "INFO-TRACE", t);
        System.out.println("< Log level " + level);
    }

    @Test
    public void testConsiderPlugin() {
        Logger initLogger = LoggerFactory.getLogger(Object.class);
        initLogger.setLevel(LogLevel.INFO);
        PluginManager.registerPlugin((PluginDescriptor)new SingletonPluginDescriptor("log-test", null, ILoggerFactory.class, p -> new ILoggerFactory(){
            private Map<String, LogLevel> initialLevels;

            public Logger createLogger(String name) {
                LogLevel initialLevel;
                FallbackLogger result = new FallbackLogger(name);
                if (this.initialLevels != null && null != (initialLevel = this.initialLevels.get(name))) {
                    result.setLevel(initialLevel);
                }
                return result;
            }

            public void initialLevels(Map<String, LogLevel> levels) {
                this.initialLevels = levels;
            }
        }));
        LoggerFactory.considerPlugin();
        Logger sndLogger = LoggerFactory.getLogger(Object.class);
        Assert.assertTrue((initLogger != sndLogger ? 1 : 0) != 0);
        Assert.assertEquals((Object)initLogger.getLevel(), (Object)sndLogger.getLevel());
    }
}

