/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.logging;

import de.iip_ecosphere.platform.support.logging.LogLevel;
import de.iip_ecosphere.platform.support.logging.Logger;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class FallbackLogger
implements Logger {
    private static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final String PLACEHOLDER = "{}";
    private static Map<Class<?>, Function<Object, Object>> stringConverter = new HashMap();
    private String name;
    private LogLevel level = LogLevel.ERROR;
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private Logger.Emitter emitter = (lvl, name, msg, th, out) -> this.emit(lvl, msg, th, out);

    public FallbackLogger(String name2) {
        this.name = name2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean setEmitter(Logger.Emitter emitter) {
        boolean changed = false;
        if (null != emitter) {
            this.emitter = emitter;
            changed = true;
        }
        return changed;
    }

    public void setStreams(PrintStream out, PrintStream err) {
        if (null != out) {
            this.out = out;
        }
        if (null != err) {
            this.err = err;
        }
    }

    @Override
    public boolean setLevel(LogLevel level) {
        this.level = level;
        return true;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public void trace(String msg) {
        this.log(LogLevel.TRACE, msg, null, this.out);
    }

    @Override
    public void trace(String format, Object arg) {
        this.logArgs(LogLevel.TRACE, format, this.out, arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.logArgs(LogLevel.TRACE, format, this.out, arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.logArgs(LogLevel.TRACE, format, this.out, arguments);
    }

    @Override
    public void trace(String msg, Throwable th) {
        this.log(LogLevel.TRACE, msg, th, this.out);
    }

    @Override
    public void debug(String msg) {
        this.log(LogLevel.DEBUG, msg, null, this.out);
    }

    @Override
    public void debug(String format, Object arg) {
        this.logArgs(LogLevel.DEBUG, format, this.out, arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.logArgs(LogLevel.DEBUG, format, this.out, arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.logArgs(LogLevel.DEBUG, format, this.out, arguments);
    }

    @Override
    public void debug(String msg, Throwable th) {
        this.log(LogLevel.DEBUG, msg, th, this.out);
    }

    @Override
    public void info(String msg) {
        this.log(LogLevel.INFO, msg, null, this.out);
    }

    @Override
    public void info(String format, Object arg) {
        this.logArgs(LogLevel.INFO, format, this.out, arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.logArgs(LogLevel.INFO, format, this.out, arg1, arg2);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.logArgs(LogLevel.INFO, format, this.out, arguments);
    }

    @Override
    public void info(String msg, Throwable th) {
        this.log(LogLevel.INFO, msg, th, this.out);
    }

    @Override
    public void warn(String msg) {
        this.log(LogLevel.WARN, msg, null, this.out);
    }

    @Override
    public void warn(String format, Object arg) {
        this.logArgs(LogLevel.WARN, format, this.out, arg);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.logArgs(LogLevel.WARN, format, this.out, arg1, arg2);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.logArgs(LogLevel.WARN, format, this.out, arguments);
    }

    @Override
    public void warn(String msg, Throwable th) {
        this.log(LogLevel.WARN, msg, th, this.out);
    }

    @Override
    public void error(String msg) {
        this.log(LogLevel.ERROR, msg, null, this.err);
    }

    @Override
    public void error(String format, Object arg) {
        this.logArgs(LogLevel.ERROR, format, this.err, arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.logArgs(LogLevel.ERROR, format, this.err, arg1, arg2);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.logArgs(LogLevel.ERROR, format, this.err, arguments);
    }

    @Override
    public void error(String msg, Throwable th) {
        this.log(LogLevel.ERROR, msg, th, this.err);
    }

    private boolean isEnabled(LogLevel level) {
        return level.isEnabled(this.level);
    }

    private void emit(LogLevel level, String msg, Throwable th, PrintStream out) {
        out.print(DATEFORMAT.format(new Date()));
        out.print(" [");
        out.print(Thread.currentThread().getName());
        out.print("] ");
        out.print((Object)level);
        out.print(" ");
        out.print(FallbackLogger.abbreviate(this.name));
        out.print(" - ");
        out.println(msg);
        if (null != th) {
            th.printStackTrace(out);
        }
    }

    private void log(LogLevel level, String msg, Throwable th, PrintStream out) {
        if (this.isEnabled(level)) {
            this.emitter.emit(level, this.name, msg, th, out);
        }
    }

    public static String abbreviate(String name) {
        int dotPos;
        StringBuilder result = new StringBuilder(name);
        for (int startPos = 1; startPos < result.length() && (dotPos = result.indexOf(".", startPos)) > 0; startPos += 2) {
            if (dotPos - 1 < startPos) continue;
            result.delete(startPos, dotPos);
        }
        return result.toString();
    }

    private String toString(Object arg) {
        Function<Object, Object> conv;
        if (arg instanceof Object[]) {
            arg = Arrays.toString((Object[])arg);
        } else if (arg != null && null != (conv = stringConverter.get(arg.getClass()))) {
            arg = conv.apply(arg);
        }
        return null == arg ? "null" : arg.toString();
    }

    private void logArgs(LogLevel level, String format, PrintStream out, Object arg) {
        if (this.isEnabled(level)) {
            String msg = FallbackLogger.replaceOnce(format, PLACEHOLDER, this.toString(arg));
            this.log(level, msg, null, out);
        }
    }

    private void logArgs(LogLevel level, String format, PrintStream out, Object arg1, Object arg2) {
        if (this.isEnabled(level)) {
            String msg = FallbackLogger.replaceOnce(format, PLACEHOLDER, this.toString(arg1));
            msg = FallbackLogger.replaceOnce(msg, PLACEHOLDER, this.toString(arg2));
            this.log(level, msg, null, out);
        }
    }

    private void logArgs(LogLevel level, String format, PrintStream out, Object[] args) {
        if (this.isEnabled(level)) {
            String msg = format;
            for (int a = 0; a < args.length; ++a) {
                msg = FallbackLogger.replaceOnce(msg, PLACEHOLDER, this.toString(args[a]));
            }
            this.log(level, msg, null, out);
        }
    }

    private static String replaceOnce(String text, String searchString, String replacement) {
        String result = text;
        int pos = text.indexOf(searchString);
        if (pos >= 0) {
            result = text.substring(0, pos) + replacement + text.substring(pos + searchString.length());
        }
        return result;
    }

    static {
        stringConverter.put(int[].class, o -> Arrays.toString((int[])o));
        stringConverter.put(long[].class, o -> Arrays.toString((long[])o));
        stringConverter.put(byte[].class, o -> Arrays.toString((byte[])o));
        stringConverter.put(char[].class, o -> Arrays.toString((char[])o));
        stringConverter.put(float[].class, o -> Arrays.toString((float[])o));
        stringConverter.put(double[].class, o -> Arrays.toString((double[])o));
        stringConverter.put(boolean[].class, o -> Arrays.toString((double[])o));
    }
}

