/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.function.Consumer;

public class StreamGobbler
extends Thread {
    private InputStream in;
    private PrintStream out;
    private Consumer<String> consumer;

    public StreamGobbler(InputStream in, PrintStream out) {
        this.in = in;
        this.out = out;
        this.start();
    }

    public StreamGobbler addConsumer(Consumer<String> consumer) {
        this.consumer = consumer;
        return this;
    }

    @Override
    public void run() {
        try {
            BufferedReader input = new BufferedReader(new InputStreamReader(this.in));
            String line = null;
            while ((line = input.readLine()) != null) {
                this.out.println(line);
                if (null == this.consumer) continue;
                this.consumer.accept(line);
            }
        }
        catch (IOException e) {
            System.err.println("Reading process stream failed: " + e.getMessage());
        }
    }

    public static void attach(Process process) {
        StreamGobbler.attach(process, null, null);
    }

    public static void attach(Process process, Consumer<String> outConsumer, Consumer<String> errConsumer) {
        StreamGobbler.attach(process, System.out, outConsumer, System.err, errConsumer);
    }

    public static void attach(Process process, PrintStream out, Consumer<String> outConsumer, PrintStream err, Consumer<String> errConsumer) {
        new StreamGobbler(process.getInputStream(), out).addConsumer(outConsumer);
        new StreamGobbler(process.getErrorStream(), err).addConsumer(errConsumer);
    }
}

