/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;

public class FileUtilsTest {
    private static int numberTestFiles = 26;
    private static int numberTestNotServiceFiles = 20;

    protected static void setNumberTestFiles(int number) {
        numberTestFiles = number;
    }

    protected static void setNumberTestNotServiceFiles(int number) {
        numberTestNotServiceFiles = number;
    }

    @Test
    public void testTempDir() {
        Assert.assertNotNull((Object)FileUtils.getTempDirectoryPath());
        Assert.assertNotNull((Object)FileUtils.getTempDirectory());
    }

    @Test
    public void testCreateTmpFolder() throws IOException {
        String tmp = FileUtils.getTempDirectoryPath();
        File created = FileUtils.createTmpFolder((String)"support.test");
        Assert.assertTrue((boolean)created.toString().startsWith(tmp));
        Assert.assertTrue((boolean)created.exists());
        Assert.assertTrue((boolean)created.canRead());
        Assert.assertTrue((boolean)created.canWrite());
        FileUtils.deleteQuietly((File)created);
        FileUtils.deleteQuietly(null);
        File f = File.createTempFile("support.boot", "tmp");
        FileUtils.deleteQuietly((File)f);
    }

    @Test
    public void testCloseQuietly() {
        FileUtils.closeQuietly(null);
        Closeable cl = new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        };
        FileUtils.closeQuietly((Closeable)cl);
    }

    @Test
    public void testListFiles() {
        File f = new File("src/test/resources");
        AtomicInteger fileCount = new AtomicInteger();
        Consumer<File> fileCountUpdater = g -> fileCount.incrementAndGet();
        FileUtils.listFiles((File)f, g -> true, fileCountUpdater);
        Assert.assertEquals((long)numberTestFiles, (long)fileCount.get());
        fileCount.set(0);
        FileUtils.listFiles((File)f, g -> !g.getName().equals("services"), fileCountUpdater);
        Assert.assertEquals((long)numberTestNotServiceFiles, (long)fileCount.get());
        f = FileUtils.createTmpFolder((String)"support-boot-test");
        fileCount.set(0);
        FileUtils.listFiles((File)f, g -> true, fileCountUpdater);
        Assert.assertEquals((long)0L, (long)fileCount.get());
        f.delete();
    }

    @Test
    public void testResolution() {
        Assert.assertNotNull((Object)FileUtils.getResolvedFile((File)new File(".")));
        Assert.assertNotNull((Object)FileUtils.getResolvedPath((File)new File("."), (String)""));
        Assert.assertNotNull((Object)FileUtils.getResolvedPath((File)new File("."), (String)"test.txt"));
    }

    @Test
    public void testSanitize() {
        Assert.assertEquals((Object)"a", (Object)FileUtils.sanitizeFileName((String)"a"));
        Assert.assertEquals((Object)"a", (Object)FileUtils.sanitizeFileName((String)"a", (boolean)false));
        Assert.assertTrue((boolean)FileUtils.sanitizeFileName((String)"a", (boolean)true).startsWith("a"));
    }

    @Test
    public void testDeleteOnExit() throws IOException {
        File f = File.createTempFile("iip-test", null);
        FileUtils.deleteOnExit((File)f);
    }

    @Test
    public void testSystemRoot() {
        File f = FileUtils.getSystemRoot();
        Assert.assertNotNull((Object)f);
        Assert.assertTrue((f.toString().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTemp() throws IOException {
        File f = FileUtils.createTmpFolder((String)"support-boot-test", (boolean)true);
        Assert.assertNotNull((Object)f);
        Assert.assertTrue((boolean)f.exists());
        f = FileUtils.createTmpFolder((String)"support-boot-test", (boolean)true);
        Assert.assertNotNull((Object)f);
        Assert.assertTrue((boolean)f.exists());
    }

    @Test
    public void testProperties() {
        Assert.assertNotNull((Object)FileUtils.getUserDirectory());
        Assert.assertNotNull((Object)FileUtils.getUserDirectoryPath());
        Assert.assertTrue((FileUtils.getUserDirectoryPath().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBase64() throws IOException {
        String text = "abc-txt0123";
        File f = File.createTempFile("support-boot-test", "tmp");
        FileUtils.base64ToFile((String)text, (File)f);
        String text2 = FileUtils.fileToBase64((File)f);
        Assert.assertEquals((Object)text, (Object)text2);
        f.delete();
    }

    @Test
    public void testDelegated() throws IOException {
        FileUtils.forceDelete(null);
        FileUtils.findFile((File)FileUtils.getTempDirectory(), (String)"notThere");
        FileUtils.getSystemRoot();
        File f = File.createTempFile("support-boot-test", "tmp");
        FileUtils.contentEquals((File)f, (File)f);
        FileUtils.write((File)f, (CharSequence)"abc-txt");
        FileUtils.write((File)f, (CharSequence)"abc-txt", (Charset)Charset.defaultCharset());
        FileUtils.writeStringToFile((File)f, (String)"abc-txt");
        FileUtils.writeStringToFile((File)f, (String)"abc-txt", (Charset)Charset.defaultCharset());
        FileUtils.readFileToString((File)f, (Charset)Charset.defaultCharset());
        FileUtils.readFileToString((File)f);
        FileUtils.copyInputStreamToFile((InputStream)ResourceLoader.getResourceAsStream((String)"identityStore.yml", (ResourceResolver[])new ResourceResolver[0]), (File)f);
        byte[] data = FileUtils.readFileToByteArray((File)f);
        FileUtils.writeByteArrayToFile((File)f, (byte[])data);
        FileUtils.writeByteArrayToFile((File)f, (byte[])data, (boolean)true);
        f.delete();
        f = FileUtils.createTmpFolder((String)"support-boot");
        File f2 = FileUtils.createTmpFolder((String)"support-boot1");
        FileUtils.copyFile((File)f, (File)f2);
        FileUtils.copyDirectory((File)f, (File)f2);
        FileUtils.copyDirectory((File)f, (File)f2, null);
        FileUtils.copyDirectory((File)f, (File)f2, null, (boolean)true);
        FileUtils.deleteDirectory((File)f);
        f.delete();
    }
}

