/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.plugins.ClasspathFilePluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.CurrentClassloaderPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.CurrentContextPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.Plugin;
import de.iip_ecosphere.platform.support.plugins.PluginBasedSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.plugins.PluginSetup;
import de.iip_ecosphere.platform.support.plugins.PluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.ResourceClasspathPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.SingletonPluginDescriptor;
import de.iip_ecosphere.platform.support.plugins.URLPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;

public class PluginManagerTest {
    private static final String JAR = "target/pluginTest.jar";

    @Test
    public void testToUrl_strings() {
        URL[] tmp;
        String testURL = "http://me.here.de";
        try {
            tmp = URLPluginSetupDescriptor.toURL((String[])new String[0]);
            Assert.assertNotNull((Object)tmp);
            Assert.assertTrue((tmp.length == 0 ? 1 : 0) != 0);
            tmp = URLPluginSetupDescriptor.toURL((String[])new String[]{"http://me.here.de"});
            Assert.assertNotNull((Object)tmp);
            Assert.assertTrue((tmp.length == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"http://me.here.de", (Object)tmp[0].toString());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"There shall be no exceptions");
        }
        try {
            URLPluginSetupDescriptor.toURL((String[])new String[]{"aa"});
            Assert.fail((String)"There shall be an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        tmp = URLPluginSetupDescriptor.toURLSafe((String[])new String[]{"http://me.here.de"});
        Assert.assertNotNull((Object)tmp);
        Assert.assertTrue((tmp.length == 1 ? 1 : 0) != 0);
        System.out.println("Next error message is intended:");
        tmp = URLPluginSetupDescriptor.toURLSafe((String[])new String[]{"aa"});
        Assert.assertNotNull((Object)tmp);
        Assert.assertTrue((tmp.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToUrl_files() {
        URL[] tmp;
        File testFile = new File(JAR);
        try {
            tmp = URLPluginSetupDescriptor.toURL((File[])new File[0]);
            Assert.assertNotNull((Object)tmp);
            Assert.assertTrue((tmp.length == 0 ? 1 : 0) != 0);
            tmp = URLPluginSetupDescriptor.toURL((File[])new File[]{testFile});
            Assert.assertNotNull((Object)tmp);
            Assert.assertTrue((tmp.length == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)testFile.toURI().toURL().toString(), (Object)tmp[0].toString());
        }
        catch (MalformedURLException e) {
            Assert.fail((String)"There shall be no exceptions");
        }
        tmp = URLPluginSetupDescriptor.toURLSafe((File[])new File[]{testFile});
        Assert.assertNotNull((Object)tmp);
        Assert.assertTrue((tmp.length == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testResourceClasspathPluginSetupDescriptor() {
        String resourceName = "test-plugin.classpath";
        URL[] url = ResourceClasspathPluginSetupDescriptor.loadResourceSafe((String)resourceName, (ResourceResolver[])new ResourceResolver[0]);
        Assert.assertNotNull((Object)url);
        Assert.assertEquals((long)1L, (long)url.length);
        Assert.assertTrue((boolean)url[0].toString().contains(JAR));
        new ResourceClasspathPluginSetupDescriptor(resourceName, new ResourceResolver[0]);
        url = ResourceClasspathPluginSetupDescriptor.loadResourceSafe((String)"test-plugin.zip", (ResourceResolver[])new ResourceResolver[0]);
        Assert.assertNotNull((Object)url);
        Assert.assertEquals((long)1L, (long)url.length);
        Assert.assertTrue((boolean)url[0].toString().contains(JAR));
    }

    @Test
    public void testPluginManager() {
        PluginSetup.setClassLoader((ClassLoader)PluginSetup.getClassLoader());
        PluginManager.loadPlugins();
        Assert.assertNull((Object)PluginManager.getPlugin((String)"whatever"));
        String id = "test-plugin";
        Plugin plugin = PluginManager.getPlugin((String)"test-plugin");
        Assert.assertNotNull((Object)plugin);
        List plugins = CollectionUtils.toList((Iterable)PluginManager.plugins());
        Assert.assertEquals((long)1L, (long)plugins.size());
        Assert.assertEquals((Object)"test-plugin", (Object)plugin.getId());
        plugin.getFurtherIds();
        plugin.getInstallDir();
        Assert.assertEquals(Server.class, (Object)plugin.getInstanceClass());
        Server plServer = (Server)plugin.getInstance();
        Assert.assertNotNull((Object)plServer);
        plServer.start();
        plServer.stop(false);
        Plugin plugin2 = PluginManager.getPlugin((String)"test-plugin", Server.class);
        Assert.assertNotNull((Object)plugin2);
        plServer = (Server)plugin2.getInstance();
        plServer.start();
        plServer.stop(false);
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        PluginBasedSetupDescriptor pDesc = new PluginBasedSetupDescriptor("test-plugin");
        Assert.assertTrue((PluginManagerTest.class.getClassLoader() == pDesc.createClassLoader(loader) ? 1 : 0) != 0);
        pDesc = new PluginBasedSetupDescriptor(Server.class);
        Assert.assertTrue((PluginManagerTest.class.getClassLoader() == pDesc.createClassLoader(loader) ? 1 : 0) != 0);
        pDesc = new PluginBasedSetupDescriptor("no-valid-id");
        Assert.assertTrue((loader == pDesc.createClassLoader(loader) ? 1 : 0) != 0);
        pDesc = new PluginBasedSetupDescriptor((String)null);
        Assert.assertTrue((loader == pDesc.createClassLoader(loader) ? 1 : 0) != 0);
        Plugin plugin3 = PluginManager.getPlugin(Server.class);
        Assert.assertNotNull((Object)plugin3);
        Plugin plugin4 = PluginManager.getPlugin(Server.class, (String)"test-plugin");
        Assert.assertNotNull((Object)plugin4);
        PluginManager.loadPlugins();
        PluginManager.cleanup();
    }

    @Test
    public void testSetup() {
        CurrentClassloaderPluginSetupDescriptor cDesc;
        ClassLoader loader = PluginManagerTest.class.getClassLoader();
        Assert.assertTrue((loader == (cDesc = CurrentClassloaderPluginSetupDescriptor.INSTANCE).createClassLoader(loader) ? 1 : 0) != 0);
        cDesc = new CurrentClassloaderPluginSetupDescriptor(loader);
        Assert.assertTrue((loader == cDesc.createClassLoader(null) ? 1 : 0) != 0);
        Assert.assertNotNull((Object)CurrentContextPluginSetupDescriptor.INSTANCE.createClassLoader(loader));
        File cpFile = new File("src/test/resources/test-plugin.classpath");
        ClasspathFilePluginSetupDescriptor cpDesc = new ClasspathFilePluginSetupDescriptor(cpFile);
        Assert.assertNotNull((Object)cpDesc.createClassLoader(loader));
        Assert.assertEquals((Object)cpFile.getParentFile(), (Object)cpDesc.getInstallDir());
        cpDesc = new ClasspathFilePluginSetupDescriptor(cpFile, true);
        Assert.assertNotNull((Object)cpDesc.createClassLoader(loader));
        SingletonPluginDescriptor pd = new SingletonPluginDescriptor("id", null, Object.class, p -> new Object());
        Assert.assertNull((Object)pd.getFurtherIds());
        List fIds = CollectionUtils.toList((Object[])new String[]{"id-a", "id-b"});
        pd = new SingletonPluginDescriptor("id", fIds, Object.class, p -> new Object());
        Assert.assertEquals((Object)"id", (Object)pd.getId());
        Assert.assertEquals((Object)fIds, (Object)pd.getFurtherIds());
        PluginDescriptor<Object> opd = new PluginDescriptor<Object>(){

            public String getId() {
                return null;
            }

            public Plugin<Object> createPlugin(File installDir) {
                return null;
            }

            public Class<Object> getType() {
                return Object.class;
            }
        };
        opd.getFurtherIds();
    }

    @Test
    public void loadAll() {
        PluginManager.cleanup();
        Predicate filter = PluginManager.setPluginClasspathFilter(f -> f.getName().endsWith("classpath"));
        PluginManager.loadAllFrom((File)new File("src/test/resources/plugins"), (PluginSetupDescriptor[])new PluginSetupDescriptor[0]);
        PluginManager.setPluginClasspathFilter((Predicate)filter);
        String id = "test-plugin";
        Plugin plugin = PluginManager.getPlugin((String)"test-plugin");
        Assert.assertNotNull((Object)plugin);
    }

    public static class MyPluginSetupDescriptor
    extends URLPluginSetupDescriptor {
        public MyPluginSetupDescriptor() {
            super(MyPluginSetupDescriptor.toURLSafe((File[])new File[]{new File(PluginManagerTest.JAR)}));
        }

        public boolean preventDuplicates() {
            return false;
        }
    }
}

