/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.TimeUtils;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class TimeUtilsTest {
    @Test
    public void testSleep() {
        long before = System.currentTimeMillis();
        TimeUtils.sleep((int)100);
        long after = System.currentTimeMillis();
        long diff = after - before;
        Assert.assertTrue((String)"Diff shall not be less than 40 ms", (60L < diff ? 1 : 0) != 0);
        Assert.assertTrue((String)"Diff shall not be larger than 200 ms", (diff < 200L ? 1 : 0) != 0);
    }

    @Test
    public void testWaitFor() {
        Assert.assertTrue((boolean)TimeUtils.waitFor(() -> false, (int)200, (int)100));
        AtomicInteger counter = new AtomicInteger(0);
        Assert.assertTrue((boolean)TimeUtils.waitFor(() -> counter.incrementAndGet() < 5, (int)-1, (int)100));
        counter.set(0);
        Assert.assertTrue((boolean)TimeUtils.waitFor(() -> counter.incrementAndGet() < 5, (int)1000, (int)100));
        counter.set(0);
        Assert.assertFalse((boolean)TimeUtils.waitFor(() -> counter.incrementAndGet() < 10, (int)300, (int)100));
    }

    @Test
    public void testFormats() throws IOException {
        String format = "yyyy-MM-dd HH:mm:ss";
        Date d = new Date();
        Date t = TimeUtils.parse((Object)d, (String)"yyyy-MM-dd HH:mm:ss");
        Assert.assertNotNull((Object)t);
        LocalDateTime l = TimeUtils.toLocalDateTime((Date)t);
        Assert.assertNotNull((Object)l);
        Assert.assertNull((Object)TimeUtils.toLocalDateTime(null));
        l = LocalDateTime.now();
        t = TimeUtils.parse((Object)l, (String)"yyyy-MM-dd HH:mm:ss");
        Assert.assertNotNull((Object)t);
        t = TimeUtils.parse((Object)"2022-10-19 08:00:21", (String)"yyyy-MM-dd HH:mm:ss");
        Assert.assertNotNull((Object)t);
        t = TimeUtils.parse(null, (String)"yyyy-MM-dd HH:mm:ss");
        Assert.assertNull((Object)t);
        t = TimeUtils.parse((Object)"2019-05-09T05:47:39.407Z", (String)"ISO8601");
        Assert.assertNotNull((Object)t);
        String s = TimeUtils.format((Date)d, (String)"ISO8601");
        Assert.assertNotNull((Object)s);
        s = TimeUtils.format((Date)d, (String)"yyyy-MM-dd HH:mm:ss");
        Assert.assertNotNull((Object)s);
        Assert.assertNull((Object)TimeUtils.toDate(null));
    }
}

