/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.DelegatingInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipUtils {
    protected ZipUtils() {
    }

    public static InputStream findFile(InputStream in, String name) throws IOException {
        return ZipUtils.findFile(in, (ZipEntry z) -> z.getName().equals(name));
    }

    public static InputStream findFile(InputStream in, Predicate<ZipEntry> pred) throws IOException {
        ZipInputStream found = null;
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            if (pred.test(zipEntry)) {
                found = zis;
                break;
            }
            zipEntry = zis.getNextEntry();
        }
        if (null == found) {
            zis.closeEntry();
        }
        return found;
    }

    public static InputStream findFile(File file, Predicate<ZipEntry> pred) throws IOException {
        ClosingInputStream found = null;
        ZipFile zf = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            if (!pred.test(zipEntry)) continue;
            found = new ClosingInputStream(zf.getInputStream(zipEntry), zf);
            break;
        }
        return found;
    }

    public static InputStream findFile(File file, String name) throws IOException {
        return ZipUtils.findFile(file, (ZipEntry z) -> z.getName().equals(name));
    }

    public static void listFiles(InputStream in, Predicate<ZipEntry> pred, Consumer<ZipEntry> consumer) throws IOException {
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            if (null == pred || pred.test(zipEntry)) {
                consumer.accept(zipEntry);
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
    }

    public static void extractZip(InputStream in, Path target) throws IOException {
        ZipUtils.extractZip(in, target, null);
    }

    public static Predicate<ZipEntry> inFolder(String folder) {
        return z -> z.getName().equals(folder) || z.getName().startsWith(folder + "/");
    }

    public static void extractZip(InputStream in, Path target, Predicate<ZipEntry> pred) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(in);){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                boolean isDirectory = zipEntry.isDirectory();
                if (null == pred || pred.test(zipEntry)) {
                    Path newPath = ZipUtils.zipSlipProtect(zipEntry, target);
                    if (isDirectory) {
                        Files.createDirectories(newPath, new FileAttribute[0]);
                    } else {
                        if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                            Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                        }
                        Files.copy(zis, newPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    private static Path zipSlipProtect(ZipEntry zipEntry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad zip entry: " + zipEntry.getName());
        }
        return normalizePath;
    }

    private static class ClosingInputStream
    extends DelegatingInputStream {
        private Closeable closeable;

        public ClosingInputStream(InputStream delegate, Closeable closeable) {
            super(delegate);
            this.closeable = closeable;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closeable.close();
        }
    }
}

