/**
 * ******************************************************************************
 * Copyright (c) {2025} The original author or authors
 *
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the Eclipse Public License 2.0 which is available 
 * at http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: Apache-2.0 OR EPL-2.0
 ********************************************************************************/

package de.iip_ecosphere.platform.support;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Simplified annotation to ignore properties. Similar to {@code JsonIgnoreProperties} in 
 * Jackson, but simplified/more generic here.
 * 
 * @author Holger Eichelberger, SSE
 */
@Retention(RUNTIME)
@Target({ANNOTATION_TYPE, TYPE, METHOD, CONSTRUCTOR, FIELD})
public @interface IgnoreProperties {

    /**
     * Property that defines whether it is ok to just ignore any
     * unrecognized properties during deserialization.
     * Does not have any effect on serialization.
     *
     * @return true if any and all unknown properties are to be ignored without
     *   exceptions (or other special handling); false otherwise.
     */
    public boolean ignoreUnknown() default false;
    
}
