/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.plugins;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.IOUtils;
import de.iip_ecosphere.platform.support.ZipUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.URLPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ResourceClasspathPluginSetupDescriptor
extends URLPluginSetupDescriptor {
    public ResourceClasspathPluginSetupDescriptor(String resourceName, ResourceResolver ... resolvers) {
        super(ResourceClasspathPluginSetupDescriptor.loadResourceSafe(resourceName, resolvers));
    }

    public static URL[] loadResourceSafe(String resourceName, ResourceResolver ... resolvers) {
        URL[] result = null;
        String folderName = resourceName;
        int pos = folderName.lastIndexOf(46);
        if (pos > 0) {
            folderName = folderName.substring(0, pos);
        }
        File dir = new File(FileUtils.getTempDirectory(), folderName);
        dir.deleteOnExit();
        dir.mkdirs();
        boolean zipExtracted = false;
        InputStream in = ResourceLoader.getResourceAsStream(resourceName, resolvers);
        if (null != in && resourceName.endsWith(".zip")) {
            try {
                ZipUtils.extractZip(in, dir.toPath());
                FileUtils.closeQuietly(in);
                in = new FileInputStream(new File(dir, "classpath"));
                zipExtracted = true;
            }
            catch (IOException e) {
                in = null;
                LoggerFactory.getLogger(URLPluginSetupDescriptor.class).error("While reading resource, extracting ZIP '{}': {} Ignoring.", (Object)resourceName, (Object)e.getMessage());
            }
        }
        if (null != in) {
            try {
                ArrayList<File> entries = new ArrayList<File>();
                String contents = IOUtils.toString(in);
                StringTokenizer tokenizer = new StringTokenizer(contents, ":;");
                while (tokenizer.hasMoreTokens()) {
                    InputStream tis;
                    String tok = tokenizer.nextToken();
                    File file = new File(tok);
                    File target = new File(dir, tok);
                    if (!zipExtracted && file.exists()) {
                        entries.add(file);
                        continue;
                    }
                    if (zipExtracted && target.exists()) {
                        entries.add(target);
                        continue;
                    }
                    if (file.exists() || target.exists() || (tis = ResourceLoader.getResourceAsStream(tok, resolvers)) == null) continue;
                    try {
                        FileUtils.copyInputStreamToFile(tis, target);
                        entries.add(target);
                    }
                    catch (IOException e1) {
                        LoggerFactory.getLogger(URLPluginSetupDescriptor.class).error("While stpring resource '{}': {} Ignoring.", (Object)resourceName, (Object)e1.getMessage());
                    }
                }
                result = ResourceClasspathPluginSetupDescriptor.toURLSafe(entries.toArray(new File[entries.size()]));
            }
            catch (IOException e) {
                LoggerFactory.getLogger(URLPluginSetupDescriptor.class).error("While reading resource '{}': {} Ignoring.", (Object)resourceName, (Object)e.getMessage());
            }
        } else {
            LoggerFactory.getLogger(URLPluginSetupDescriptor.class).error("Resource '{}' not found. Ignoring.", (Object)resourceName);
        }
        if (null == result) {
            result = new URL[]{};
        }
        return result;
    }
}

