/*
 * Decompiled with CFR 0.152.
 */
package test.de.oktoflow.platform.support.bytecode.bytebuddy;

import de.iip_ecosphere.platform.support.ConfiguredName;
import de.iip_ecosphere.platform.support.IgnoreProperties;
import de.iip_ecosphere.platform.support.bytecode.Bytecode;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.junit.Assert;
import org.junit.Test;

public class BytecodeTest {
    @Test
    public void testCreateDataClass() throws NoSuchFieldException, NoSuchMethodException, InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, InvocationTargetException {
        Bytecode.ClassBuilder builder = Bytecode.getInstance().createClassBuilder("iip.mock.Mock", Data.class, BytecodeTest.class.getClassLoader());
        builder.implement(BaseDataUnitFunctions.class);
        ((Bytecode.ClassBuilder.TypeAnnotationBuilder)builder.annotate(IgnoreProperties.class).define("ignoreUnknown", true)).build();
        ((Bytecode.ClassBuilder.FieldAnnotationBuilder)builder.defineProperty("$period", Integer.TYPE).annotate(ConfiguredName.class).define("value", "abc")).build().build();
        builder.defineProperty("$repeats", Integer.TYPE).build();
        Class cls = builder.build();
        Assert.assertNotNull((Object)cls);
        Assert.assertEquals((Object)"iip.mock.Mock", (Object)cls.getName());
        IgnoreProperties a1 = cls.getAnnotation(IgnoreProperties.class);
        Assert.assertNotNull((Object)a1);
        Assert.assertEquals((Object)true, (Object)a1.ignoreUnknown());
        Data d = (Data)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        Assert.assertNotNull((Object)d);
        Field f = cls.getDeclaredField("$period");
        Assert.assertEquals(Integer.TYPE, f.getType());
        Assert.assertTrue((boolean)Modifier.isPrivate(f.getModifiers()));
        ConfiguredName p = f.getAnnotation(ConfiguredName.class);
        Assert.assertEquals((Object)"abc", (Object)p.value());
        Method m = cls.getDeclaredMethod("set$repeats", Integer.TYPE);
        Assert.assertTrue((boolean)Modifier.isPublic(m.getModifiers()));
        Assert.assertEquals(Void.TYPE, m.getReturnType());
        m.invoke((Object)d, 2);
        m = cls.getDeclaredMethod("get$repeats", new Class[0]);
        Assert.assertEquals(Integer.TYPE, m.getReturnType());
        Assert.assertTrue((boolean)Modifier.isPublic(m.getModifiers()));
        Assert.assertEquals((Object)2, (Object)m.invoke((Object)d, new Object[0]));
        f = cls.getDeclaredField("$period");
        Assert.assertEquals(Integer.TYPE, f.getType());
        Assert.assertTrue((boolean)Modifier.isPrivate(f.getModifiers()));
        m = cls.getDeclaredMethod("set$period", Integer.TYPE);
        Assert.assertTrue((boolean)Modifier.isPublic(m.getModifiers()));
        Assert.assertEquals(Void.TYPE, m.getReturnType());
        m = cls.getDeclaredMethod("get$period", new Class[0]);
        Assert.assertEquals(Integer.TYPE, m.getReturnType());
        Assert.assertTrue((boolean)Modifier.isPublic(m.getModifiers()));
    }

    @Test
    public void testCreateBuilderClass() throws NoSuchFieldException, ClassNotFoundException {
        Class cls = ((Bytecode.ClassBuilder.FieldAnnotationBuilder)Bytecode.getInstance().createClassBuilder("MyType", Object.class, BytecodeTest.class.getClassLoader()).definePublicField("intField", Integer.TYPE).annotate(ConfiguredName.class).define("value", "bce")).build().build().definePublicField("stringField", String.class).build().build();
        Assert.assertNotNull((Object)cls);
        Assert.assertEquals((Object)"MyType", (Object)cls.getName());
        Field f = cls.getDeclaredField("intField");
        Assert.assertEquals(Integer.TYPE, f.getType());
        Assert.assertTrue((boolean)Modifier.isPublic(f.getModifiers()));
        ConfiguredName p = f.getAnnotation(ConfiguredName.class);
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"bce", (Object)p.value());
        f = cls.getDeclaredField("stringField");
        Assert.assertEquals(String.class, f.getType());
        Assert.assertTrue((boolean)Modifier.isPublic(f.getModifiers()));
        p = f.getAnnotation(ConfiguredName.class);
        Assert.assertNull((Object)p);
    }

    public static class Data {
        private int intField;

        public int getIntField() {
            return this.intField;
        }

        public void setIntField(int intField) {
            this.intField = intField;
        }
    }

    public static interface BaseDataUnitFunctions {
        public int get$period();

        public int get$repeats();

        public void set$period(int var1);

        public void set$repeats(int var1);
    }

    public static @interface MyAnnotation {
        public String value() default "";
    }
}

