/*
 * Decompiled with CFR 0.152.
 */
package test.de.oktoflow.platform.support.commons.apache;

import de.iip_ecosphere.platform.support.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.junit.Assert;
import org.junit.Test;

public class CollectionUtilsTest {
    @Test
    public void testToList() {
        ArrayList<String> data = new ArrayList<String>();
        List result = CollectionUtils.toList(data);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        data.add("HERE");
        data.add("There");
        result = CollectionUtils.toList(data.iterator());
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)data.size(), (long)result.size());
        Assert.assertEquals(data, (Object)result);
        List oResult = CollectionUtils.toList((Enumeration)new StringTokenizer("HERE, There", ", "));
        Assert.assertNotNull((Object)oResult);
        Assert.assertFalse((boolean)oResult.isEmpty());
        Assert.assertEquals((long)data.size(), (long)oResult.size());
        Assert.assertEquals(data, (Object)oResult);
    }

    @Test
    public void testToSet() {
        ArrayList<String> data = new ArrayList<String>();
        Set result = CollectionUtils.toSet(data);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        data.add("HERE");
        data.add("There");
        result = CollectionUtils.toSet(data.iterator());
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)data.size(), (long)result.size());
        for (String s : data) {
            Assert.assertTrue((boolean)result.contains(s));
        }
        Set oResult = CollectionUtils.toSet((Enumeration)new StringTokenizer("HERE, There", ", "));
        Assert.assertNotNull((Object)oResult);
        Assert.assertFalse((boolean)oResult.isEmpty());
        Assert.assertEquals((long)data.size(), (long)oResult.size());
        for (String s : data) {
            Assert.assertTrue((boolean)oResult.contains(s));
        }
        result = CollectionUtils.toSet((Object[])new String[]{"1", "2", "2"});
        Assert.assertTrue((boolean)result.contains("1"));
        Assert.assertTrue((boolean)result.contains("2"));
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testToListVarArg() {
        List tmp = CollectionUtils.toList((Object[])new String[0]);
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((long)0L, (long)tmp.size());
        tmp = CollectionUtils.toList((Object[])new String[]{"a"});
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((long)1L, (long)tmp.size());
        Assert.assertEquals((Object)"a", tmp.get(0));
        tmp = CollectionUtils.toList((Object[])new String[]{"a", "b"});
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((long)2L, (long)tmp.size());
        Assert.assertEquals((Object)"a", tmp.get(0));
        Assert.assertEquals((Object)"b", tmp.get(1));
    }

    @Test
    public void testAddListAllVarArg() {
        ArrayList tmp = new ArrayList();
        List res = CollectionUtils.addAll(tmp, (Object[])new String[0]);
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((res == tmp ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)tmp.size());
        res = CollectionUtils.addAll(tmp, (Object[])new String[]{"a"});
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((res == tmp ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)tmp.size());
        Assert.assertEquals((Object)"a", tmp.get(0));
        res = CollectionUtils.addAll(tmp, (Object[])new String[]{"a", "b"});
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((res == tmp ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)tmp.size());
        Assert.assertEquals((Object)"a", tmp.get(0));
        Assert.assertEquals((Object)"a", tmp.get(1));
        Assert.assertEquals((Object)"b", tmp.get(2));
    }

    @Test
    public void testAddSetAllVarArg() {
        HashSet tmp = new HashSet();
        Set res = CollectionUtils.addAll(tmp, (Object[])new String[0]);
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((res == tmp ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)tmp.size());
        res = CollectionUtils.addAll(tmp, (Object[])new String[]{"a"});
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((res == tmp ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)tmp.size());
        Assert.assertTrue((boolean)tmp.contains("a"));
        res = CollectionUtils.addAll(tmp, (Object[])new String[]{"a", "b"});
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((res == tmp ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)tmp.size());
        Assert.assertTrue((boolean)tmp.contains("a"));
        Assert.assertTrue((boolean)tmp.contains("b"));
    }

    @Test
    public void testToString() {
        List list = CollectionUtils.toList((Object[])new Integer[0]);
        Assert.assertEquals((Object)"", (Object)CollectionUtils.toStringSpaceSeparated((Collection)list));
        Assert.assertEquals((Object)"[]", (Object)CollectionUtils.toString((Collection)list, (String)"[", (String)"]", (String)", "));
        list = CollectionUtils.toList((Object[])new Integer[]{1});
        Assert.assertEquals((Object)"1", (Object)CollectionUtils.toStringSpaceSeparated((Collection)list));
        Assert.assertEquals((Object)"[1]", (Object)CollectionUtils.toString((Collection)list, (String)"[", (String)"]", (String)", "));
        list = CollectionUtils.toList((Object[])new Integer[]{1, 2});
        Assert.assertEquals((Object)"1 2", (Object)CollectionUtils.toStringSpaceSeparated((Collection)list));
        Assert.assertEquals((Object)"[1, 2]", (Object)CollectionUtils.toString((Collection)list, (String)"[", (String)"]", (String)", "));
    }

    @Test
    public void testReverse() {
        CollectionUtils.reverse(null);
        Object[] data = new String[]{};
        CollectionUtils.reverse((Object[])data);
        Assert.assertArrayEquals((Object[])new String[0], (Object[])data);
        data = new String[]{"a"};
        CollectionUtils.reverse((Object[])data);
        Assert.assertArrayEquals((Object[])new String[]{"a"}, (Object[])data);
        data = new String[]{"a", "b"};
        CollectionUtils.reverse((Object[])data);
        Assert.assertArrayEquals((Object[])new String[]{"b", "a"}, (Object[])data);
    }
}

