/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jsensors.standalone;

import com.profesorfalken.jsensors.JSensors;
import com.profesorfalken.jsensors.model.components.Component;
import com.profesorfalken.jsensors.model.components.Components;
import com.profesorfalken.jsensors.model.components.Cpu;
import com.profesorfalken.jsensors.model.components.Disk;
import com.profesorfalken.jsensors.model.components.Gpu;
import com.profesorfalken.jsensors.model.sensors.Fan;
import com.profesorfalken.jsensors.model.sensors.Load;
import com.profesorfalken.jsensors.model.sensors.Temperature;
import java.util.List;
import java.util.Map;

public class ConsoleOutput {
    public static void showOutput(Map<String, String> config) {
        List<Disk> list;
        List<Gpu> gpus;
        System.out.println("Scanning sensors data...");
        Components components = JSensors.get.config(config).components();
        List<Cpu> cpus = components.cpus;
        if (cpus != null) {
            for (Cpu cpu : cpus) {
                System.out.println("Found CPU component: " + cpu.name);
                ConsoleOutput.readComponent(cpu);
            }
        }
        if ((gpus = components.gpus) != null) {
            for (Gpu gpu : gpus) {
                System.out.println("Found GPU component: " + gpu.name);
                ConsoleOutput.readComponent(gpu);
            }
        }
        if ((list = components.disks) != null) {
            for (Disk disk : list) {
                System.out.println("Found disk component: " + disk.name);
                ConsoleOutput.readComponent(disk);
            }
        }
    }

    private static void readComponent(Component component) {
        if (component.sensors != null) {
            System.out.println("Sensors: ");
            List<Temperature> temps = component.sensors.temperatures;
            for (Temperature temperature : temps) {
                System.out.println(temperature.name + ": " + temperature.value + " C");
            }
            List<Fan> fans = component.sensors.fans;
            for (Fan fan : fans) {
                System.out.println(fan.name + ": " + fan.value + " RPM");
            }
            List<Load> list = component.sensors.loads;
            for (Load load : list) {
                System.out.println(load.name + ": " + load.value);
            }
        }
    }
}

