/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.ElementsAccess;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Invokable;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.function.IOSupplier;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ResolvingInvocablesCreator
implements InvocablesCreator {
    private InvocablesCreator origin;
    private Function<String, String> unqualifier;
    private IOSupplier<Aas> aasSupplier;
    private String[] elementPath;

    public ResolvingInvocablesCreator(InvocablesCreator origin, IOSupplier<Aas> aasSupplier, String[] elementPath, Function<String, String> unqualifier) {
        this.origin = origin;
        this.unqualifier = null == unqualifier ? s -> s : unqualifier;
        this.aasSupplier = aasSupplier;
        this.elementPath = elementPath;
    }

    @Override
    public Invokable createGetter(String name) {
        return new PropertyResolvingInvokable(null, this.unqualifier.apply(name));
    }

    @Override
    public Invokable createSetter(String name) {
        return new PropertyResolvingInvokable(null, this.unqualifier.apply(name));
    }

    @Override
    public Invokable createInvocable(String name) {
        return new OperationResolvingInvokable(this.origin.createInvocable(name), this.unqualifier.apply(name));
    }

    private class PropertyResolvingInvokable
    extends AbstractResolvingInvokable {
        private Property property;

        private PropertyResolvingInvokable(Invokable delegate, String name) {
            super(delegate, name);
        }

        private boolean resolveProperty() {
            ElementsAccess parent;
            if (null == this.property && null != (parent = this.resolveParent())) {
                this.property = parent.getProperty(this.getName());
            }
            return this.property != null;
        }

        @Override
        public Supplier<Object> getGetter() {
            return () -> {
                Object result = null;
                if (this.resolveProperty()) {
                    try {
                        return this.property.getValue();
                    }
                    catch (ExecutionException e) {
                        LoggerFactory.getLogger(this.getClass()).error("While getting value of {}: {}", (Object)this.getName(), (Object)e.getMessage());
                    }
                }
                return result;
            };
        }

        @Override
        public Consumer<Object> getSetter() {
            return v -> {
                if (this.resolveProperty()) {
                    try {
                        this.property.setValue(v);
                    }
                    catch (ExecutionException e) {
                        LoggerFactory.getLogger(this.getClass()).error("While setting value of {}: {}", (Object)this.getName(), (Object)e.getMessage());
                    }
                }
            };
        }
    }

    private class OperationResolvingInvokable
    extends AbstractResolvingInvokable {
        private Operation operation;

        private OperationResolvingInvokable(Invokable delegate, String name) {
            super(delegate, name);
        }

        private boolean resolveOperation() {
            ElementsAccess parent;
            if (null == this.operation && null != (parent = this.resolveParent())) {
                this.operation = parent.getOperation(this.getName());
            }
            return this.operation != null;
        }

        @Override
        public Function<Object[], Object> getOperation() {
            return args -> {
                Object result = null;
                if (this.resolveOperation()) {
                    try {
                        return this.operation.invoke(args);
                    }
                    catch (ExecutionException e) {
                        LoggerFactory.getLogger(this.getClass()).error("While invoking {}: {}", (Object)this.getName(), (Object)e.getMessage());
                    }
                } else {
                    LoggerFactory.getLogger(this.getClass()).warn("Cannot resolve AAS operation `{}`", (Object)this.getName());
                }
                return result;
            };
        }
    }

    private abstract class AbstractResolvingInvokable
    implements Invokable {
        private Invokable delegate;
        private String name;

        protected AbstractResolvingInvokable(Invokable delegate, String name) {
            this.delegate = delegate;
            this.name = name;
        }

        protected ElementsAccess resolveParent() {
            AasFactory factory = AasFactory.getInstance();
            ElementsAccess parent = null;
            try {
                Aas aas = (Aas)ResolvingInvocablesCreator.this.aasSupplier.get();
                int pathPos = 0;
                parent = aas.getSubmodel(factory.fixId(ResolvingInvocablesCreator.this.elementPath[pathPos++]));
                while (parent != null && pathPos < ResolvingInvocablesCreator.this.elementPath.length) {
                    SubmodelElement elt;
                    parent = (elt = parent.getSubmodelElement(factory.fixId(ResolvingInvocablesCreator.this.elementPath[pathPos++]))) instanceof ElementsAccess ? (ElementsAccess)((Object)elt) : null;
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("While resolving {}: {}", (Object)this.name, (Object)e.getMessage());
            }
            return parent;
        }

        protected String getName() {
            return this.name;
        }

        @Override
        public String getUrl() {
            return null == this.delegate ? null : this.delegate.getUrl();
        }

        @Override
        public String getSubmodelRepositoryUrl() {
            return null == this.delegate ? null : this.delegate.getSubmodelRepositoryUrl();
        }

        @Override
        public void execute(Invokable.OperationInvocation invocation) throws IOException {
            if (null != this.delegate) {
                this.delegate.equals(invocation);
            }
        }
    }
}

