/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.types.timeSeriesData;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.IdentifierType;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementCollectionBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.types.common.Utils;
import java.util.Date;

public class TimeSeriesBuilder
extends DelegatingSubmodelBuilder {
    private boolean createMultiLanguageProperties = true;
    private int metadataCounter = 0;
    private int segmentsCounter = 0;

    public TimeSeriesBuilder(Aas.AasBuilder aasBuilder, String identifier) {
        this(aasBuilder, identifier, "TimeSeries");
    }

    private TimeSeriesBuilder(Aas.AasBuilder aasBuilder, String identifier, String idShort) {
        super(aasBuilder.createSubmodelBuilder(idShort, identifier));
        this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/1/1"));
    }

    public void setCreateMultiLanguageProperties(boolean createMultiLanguageProperties) {
        this.createMultiLanguageProperties = createMultiLanguageProperties;
    }

    public MetadataBuilder createMetadataBuilder() {
        ++this.metadataCounter;
        return new MetadataBuilder(this);
    }

    public SegmentsBuilder createSegmentsBuilder() {
        ++this.segmentsCounter;
        return new SegmentsBuilder(this);
    }

    @Override
    public Submodel build() {
        Utils.assertThat(this.metadataCounter == 1, "Cardinality {} of Metadata must be equal 1.", this.metadataCounter);
        Utils.assertThat(this.segmentsCounter == 1, "Cardinality {} of Segments must be equal 1.", this.segmentsCounter);
        return super.build();
    }

    public class MetadataBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int nameCounter;
        private int descriptionCounter;
        private int recordCounter;

        protected MetadataBuilder(DelegatingSubmodelBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("Metadata"), smBuilder);
            this.nameCounter = 0;
            this.descriptionCounter = 0;
            this.recordCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Metadata/1/1"));
        }

        protected MetadataBuilder(DelegatingSubmodelBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("Metadata", nr)), smBuilder);
            this.nameCounter = 0;
            this.descriptionCounter = 0;
            this.recordCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Metadata/1/1"));
        }

        public MetadataBuilder setName(LangString ... name) {
            if (name.length > 0) {
                ++this.nameCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), TimeSeriesBuilder.this.createMultiLanguageProperties, "Name", IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Metadata/Name/1/1"), name);
            return this;
        }

        public MetadataBuilder setDescription(LangString ... description) {
            if (description.length > 0) {
                ++this.descriptionCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), TimeSeriesBuilder.this.createMultiLanguageProperties, "Description", IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Metadata/Description/1/1"), description);
            return this;
        }

        public RecordBuilder createRecordBuilder() {
            ++this.recordCounter;
            return new RecordBuilder(this);
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(this.nameCounter == 1, "Cardinality {} of Name must be equal 1.", this.nameCounter);
            Utils.assertThat(0 <= this.descriptionCounter && this.descriptionCounter <= 1, "Cardinality {} of Description must be greater or equal 0 and less or equal 1.", this.descriptionCounter);
            Utils.assertThat(this.recordCounter == 1, "Cardinality {} of Record must be equal 1.", this.recordCounter);
            return super.build();
        }
    }

    public class SegmentsBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int externalSegmentCounter;
        private int linkedSegmentCounter;
        private int internalSegmentCounter;

        protected SegmentsBuilder(DelegatingSubmodelBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("Segments"), smBuilder);
            this.externalSegmentCounter = 0;
            this.linkedSegmentCounter = 0;
            this.internalSegmentCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segments/1/1"));
        }

        protected SegmentsBuilder(DelegatingSubmodelBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("Segments", nr)), smBuilder);
            this.externalSegmentCounter = 0;
            this.linkedSegmentCounter = 0;
            this.internalSegmentCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segments/1/1"));
        }

        public ExternalSegmentBuilder createExternalSegmentBuilder() {
            return new ExternalSegmentBuilder(this, ++this.externalSegmentCounter);
        }

        public LinkedSegmentBuilder createLinkedSegmentBuilder() {
            return new LinkedSegmentBuilder(this, ++this.linkedSegmentCounter);
        }

        public InternalSegmentBuilder createInternalSegmentBuilder() {
            return new InternalSegmentBuilder(this, ++this.internalSegmentCounter);
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(0 <= this.externalSegmentCounter, "Cardinality {} of ExternalSegment must be greater or equal 0.", this.externalSegmentCounter);
            Utils.assertThat(0 <= this.linkedSegmentCounter, "Cardinality {} of LinkedSegment must be greater or equal 0.", this.linkedSegmentCounter);
            Utils.assertThat(0 <= this.internalSegmentCounter, "Cardinality {} of InternalSegment must be greater or equal 0.", this.internalSegmentCounter);
            return super.build();
        }
    }

    public class RecordsBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int recordCounter;

        protected RecordsBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("Records"), smBuilder);
            this.recordCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Records/1/1"));
        }

        protected RecordsBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("Records", nr)), smBuilder);
            this.recordCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Records/1/1"));
        }

        public RecordBuilder createRecordBuilder() {
            return new RecordBuilder(this, ++this.recordCounter);
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(0 <= this.recordCounter, "Cardinality {} of Record must be greater or equal 0.", this.recordCounter);
            return super.build();
        }
    }

    public class InternalSegmentBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int nameCounter;
        private int descriptionCounter;
        private int recordCountCounter;
        private int startTimeCounter;
        private int endTimeCounter;
        private int durationCounter;
        private int samplingIntervalCounter;
        private int samplingRateCounter;
        private int stateCounter;
        private int lastUpdateCounter;
        private int recordsCounter;

        protected InternalSegmentBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("InternalSegment"), smBuilder);
            this.nameCounter = 0;
            this.descriptionCounter = 0;
            this.recordCountCounter = 0;
            this.startTimeCounter = 0;
            this.endTimeCounter = 0;
            this.durationCounter = 0;
            this.samplingIntervalCounter = 0;
            this.samplingRateCounter = 0;
            this.stateCounter = 0;
            this.lastUpdateCounter = 0;
            this.recordsCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segments/InternalSegment/1/1"));
        }

        protected InternalSegmentBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("InternalSegment", nr)), smBuilder);
            this.nameCounter = 0;
            this.descriptionCounter = 0;
            this.recordCountCounter = 0;
            this.startTimeCounter = 0;
            this.endTimeCounter = 0;
            this.durationCounter = 0;
            this.samplingIntervalCounter = 0;
            this.samplingRateCounter = 0;
            this.stateCounter = 0;
            this.lastUpdateCounter = 0;
            this.recordsCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segments/InternalSegment/1/1"));
        }

        public InternalSegmentBuilder setName(LangString ... name) {
            if (name.length > 0) {
                ++this.nameCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), TimeSeriesBuilder.this.createMultiLanguageProperties, "Name", IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/Name/1/1"), name);
            return this;
        }

        public InternalSegmentBuilder setDescription(LangString ... description) {
            if (description.length > 0) {
                ++this.descriptionCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), TimeSeriesBuilder.this.createMultiLanguageProperties, "Description", IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/Description/1/1"), description);
            return this;
        }

        public InternalSegmentBuilder setRecordCount(long recordCount) {
            ++this.recordCountCounter;
            this.createPropertyBuilder("RecordCount").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/RecordCount/1/1")).setValue(Type.INT64, recordCount).build();
            return this;
        }

        public InternalSegmentBuilder setStartTime(Date startTime) {
            ++this.startTimeCounter;
            this.createPropertyBuilder("StartTime").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/StartTime/1/1")).setValue(Type.DATE_TIME, startTime).build();
            return this;
        }

        public InternalSegmentBuilder setEndTime(Date endTime) {
            ++this.endTimeCounter;
            this.createPropertyBuilder("EndTime").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/EndTime/1/1")).setValue(Type.DATE_TIME, endTime).build();
            return this;
        }

        public InternalSegmentBuilder setDuration(String duration) {
            ++this.durationCounter;
            this.createPropertyBuilder("Duration").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/Duration/1/1")).setValue(Type.STRING, duration).build();
            return this;
        }

        public InternalSegmentBuilder setSamplingInterval(long samplingInterval) {
            ++this.samplingIntervalCounter;
            this.createPropertyBuilder("SamplingInterval").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/SamplingInterval/1/1")).setValue(Type.INT64, samplingInterval).build();
            return this;
        }

        public InternalSegmentBuilder setSamplingRate(long samplingRate) {
            ++this.samplingRateCounter;
            this.createPropertyBuilder("SamplingRate").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/SamplingRate/1/1")).setValue(Type.INT64, samplingRate).build();
            return this;
        }

        public InternalSegmentBuilder setState(State state) {
            ++this.stateCounter;
            this.createPropertyBuilder("State").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/State/1/1")).setValue(Type.STRING, state.getValue()).build();
            return this;
        }

        public InternalSegmentBuilder setLastUpdate(Date lastUpdate) {
            ++this.lastUpdateCounter;
            this.createPropertyBuilder("LastUpdate").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/LastUpdate/1/1")).setValue(Type.DATE_TIME, lastUpdate).build();
            return this;
        }

        public RecordsBuilder createRecordsBuilder() {
            ++this.recordsCounter;
            return new RecordsBuilder(this);
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(0 <= this.nameCounter && this.nameCounter <= 1, "Cardinality {} of Name must be greater or equal 0 and less or equal 1.", this.nameCounter);
            Utils.assertThat(0 <= this.descriptionCounter && this.descriptionCounter <= 1, "Cardinality {} of Description must be greater or equal 0 and less or equal 1.", this.descriptionCounter);
            Utils.assertThat(0 <= this.recordCountCounter && this.recordCountCounter <= 1, "Cardinality {} of RecordCount must be greater or equal 0 and less or equal 1.", this.recordCountCounter);
            Utils.assertThat(0 <= this.startTimeCounter && this.startTimeCounter <= 1, "Cardinality {} of StartTime must be greater or equal 0 and less or equal 1.", this.startTimeCounter);
            Utils.assertThat(0 <= this.endTimeCounter && this.endTimeCounter <= 1, "Cardinality {} of EndTime must be greater or equal 0 and less or equal 1.", this.endTimeCounter);
            Utils.assertThat(0 <= this.durationCounter && this.durationCounter <= 1, "Cardinality {} of Duration must be greater or equal 0 and less or equal 1.", this.durationCounter);
            Utils.assertThat(0 <= this.samplingIntervalCounter && this.samplingIntervalCounter <= 1, "Cardinality {} of SamplingInterval must be greater or equal 0 and less or equal 1.", this.samplingIntervalCounter);
            Utils.assertThat(0 <= this.samplingRateCounter && this.samplingRateCounter <= 1, "Cardinality {} of SamplingRate must be greater or equal 0 and less or equal 1.", this.samplingRateCounter);
            Utils.assertThat(0 <= this.stateCounter && this.stateCounter <= 1, "Cardinality {} of State must be greater or equal 0 and less or equal 1.", this.stateCounter);
            Utils.assertThat(0 <= this.lastUpdateCounter && this.lastUpdateCounter <= 1, "Cardinality {} of LastUpdate must be greater or equal 0 and less or equal 1.", this.lastUpdateCounter);
            Utils.assertThat(this.recordsCounter == 1, "Cardinality {} of Records must be equal 1.", this.recordsCounter);
            return super.build();
        }
    }

    public class LinkedSegmentBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int nameCounter;
        private int descriptionCounter;
        private int recordCountCounter;
        private int startTimeCounter;
        private int endTimeCounter;
        private int durationCounter;
        private int samplingIntervalCounter;
        private int samplingRateCounter;
        private int stateCounter;
        private int lastUpdateCounter;
        private int endpointCounter;
        private int queryCounter;

        protected LinkedSegmentBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("LinkedSegment"), smBuilder);
            this.nameCounter = 0;
            this.descriptionCounter = 0;
            this.recordCountCounter = 0;
            this.startTimeCounter = 0;
            this.endTimeCounter = 0;
            this.durationCounter = 0;
            this.samplingIntervalCounter = 0;
            this.samplingRateCounter = 0;
            this.stateCounter = 0;
            this.lastUpdateCounter = 0;
            this.endpointCounter = 0;
            this.queryCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segments/LinkedSegment/1/1"));
        }

        protected LinkedSegmentBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("LinkedSegment", nr)), smBuilder);
            this.nameCounter = 0;
            this.descriptionCounter = 0;
            this.recordCountCounter = 0;
            this.startTimeCounter = 0;
            this.endTimeCounter = 0;
            this.durationCounter = 0;
            this.samplingIntervalCounter = 0;
            this.samplingRateCounter = 0;
            this.stateCounter = 0;
            this.lastUpdateCounter = 0;
            this.endpointCounter = 0;
            this.queryCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segments/LinkedSegment/1/1"));
        }

        public LinkedSegmentBuilder setName(LangString ... name) {
            if (name.length > 0) {
                ++this.nameCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), TimeSeriesBuilder.this.createMultiLanguageProperties, "Name", IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/Name/1/1"), name);
            return this;
        }

        public LinkedSegmentBuilder setDescription(LangString ... description) {
            if (description.length > 0) {
                ++this.descriptionCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), TimeSeriesBuilder.this.createMultiLanguageProperties, "Description", IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/Description/1/1"), description);
            return this;
        }

        public LinkedSegmentBuilder setRecordCount(long recordCount) {
            ++this.recordCountCounter;
            this.createPropertyBuilder("RecordCount").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/RecordCount/1/1")).setValue(Type.INT64, recordCount).build();
            return this;
        }

        public LinkedSegmentBuilder setStartTime(Date startTime) {
            ++this.startTimeCounter;
            this.createPropertyBuilder("StartTime").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/StartTime/1/1")).setValue(Type.DATE_TIME, startTime).build();
            return this;
        }

        public LinkedSegmentBuilder setEndTime(Date endTime) {
            ++this.endTimeCounter;
            this.createPropertyBuilder("EndTime").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/EndTime/1/1")).setValue(Type.DATE_TIME, endTime).build();
            return this;
        }

        public LinkedSegmentBuilder setDuration(String duration) {
            ++this.durationCounter;
            this.createPropertyBuilder("Duration").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/Duration/1/1")).setValue(Type.STRING, duration).build();
            return this;
        }

        public LinkedSegmentBuilder setSamplingInterval(long samplingInterval) {
            ++this.samplingIntervalCounter;
            this.createPropertyBuilder("SamplingInterval").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/SamplingInterval/1/1")).setValue(Type.INT64, samplingInterval).build();
            return this;
        }

        public LinkedSegmentBuilder setSamplingRate(long samplingRate) {
            ++this.samplingRateCounter;
            this.createPropertyBuilder("SamplingRate").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/SamplingRate/1/1")).setValue(Type.INT64, samplingRate).build();
            return this;
        }

        public LinkedSegmentBuilder setState(State state) {
            ++this.stateCounter;
            this.createPropertyBuilder("State").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/State/1/1")).setValue(Type.STRING, state.getValue()).build();
            return this;
        }

        public LinkedSegmentBuilder setLastUpdate(Date lastUpdate) {
            ++this.lastUpdateCounter;
            this.createPropertyBuilder("LastUpdate").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/LastUpdate/1/1")).setValue(Type.DATE_TIME, lastUpdate).build();
            return this;
        }

        public LinkedSegmentBuilder setEndpoint(String endpoint) {
            ++this.endpointCounter;
            this.createPropertyBuilder("Endpoint").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Endpoint/1/1")).setValue(Type.STRING, endpoint).build();
            return this;
        }

        public LinkedSegmentBuilder setQuery(String query) {
            ++this.queryCounter;
            this.createPropertyBuilder("Query").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Query/1/1")).setValue(Type.STRING, query).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(0 <= this.nameCounter && this.nameCounter <= 1, "Cardinality {} of Name must be greater or equal 0 and less or equal 1.", this.nameCounter);
            Utils.assertThat(0 <= this.descriptionCounter && this.descriptionCounter <= 1, "Cardinality {} of Description must be greater or equal 0 and less or equal 1.", this.descriptionCounter);
            Utils.assertThat(0 <= this.recordCountCounter && this.recordCountCounter <= 1, "Cardinality {} of RecordCount must be greater or equal 0 and less or equal 1.", this.recordCountCounter);
            Utils.assertThat(0 <= this.startTimeCounter && this.startTimeCounter <= 1, "Cardinality {} of StartTime must be greater or equal 0 and less or equal 1.", this.startTimeCounter);
            Utils.assertThat(0 <= this.endTimeCounter && this.endTimeCounter <= 1, "Cardinality {} of EndTime must be greater or equal 0 and less or equal 1.", this.endTimeCounter);
            Utils.assertThat(0 <= this.durationCounter && this.durationCounter <= 1, "Cardinality {} of Duration must be greater or equal 0 and less or equal 1.", this.durationCounter);
            Utils.assertThat(0 <= this.samplingIntervalCounter && this.samplingIntervalCounter <= 1, "Cardinality {} of SamplingInterval must be greater or equal 0 and less or equal 1.", this.samplingIntervalCounter);
            Utils.assertThat(0 <= this.samplingRateCounter && this.samplingRateCounter <= 1, "Cardinality {} of SamplingRate must be greater or equal 0 and less or equal 1.", this.samplingRateCounter);
            Utils.assertThat(0 <= this.stateCounter && this.stateCounter <= 1, "Cardinality {} of State must be greater or equal 0 and less or equal 1.", this.stateCounter);
            Utils.assertThat(0 <= this.lastUpdateCounter && this.lastUpdateCounter <= 1, "Cardinality {} of LastUpdate must be greater or equal 0 and less or equal 1.", this.lastUpdateCounter);
            Utils.assertThat(this.endpointCounter == 1, "Cardinality {} of Endpoint must be equal 1.", this.endpointCounter);
            Utils.assertThat(this.queryCounter == 1, "Cardinality {} of Query must be equal 1.", this.queryCounter);
            return super.build();
        }
    }

    public class ExternalSegmentBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int nameCounter;
        private int descriptionCounter;
        private int recordCountCounter;
        private int startTimeCounter;
        private int endTimeCounter;
        private int durationCounter;
        private int samplingIntervalCounter;
        private int samplingRateCounter;
        private int stateCounter;
        private int lastUpdateCounter;
        private int fileCounter;
        private int blobCounter;

        protected ExternalSegmentBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("ExternalSegment"), smBuilder);
            this.nameCounter = 0;
            this.descriptionCounter = 0;
            this.recordCountCounter = 0;
            this.startTimeCounter = 0;
            this.endTimeCounter = 0;
            this.durationCounter = 0;
            this.samplingIntervalCounter = 0;
            this.samplingRateCounter = 0;
            this.stateCounter = 0;
            this.lastUpdateCounter = 0;
            this.fileCounter = 0;
            this.blobCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segments/ExternalSegment/1/1"));
        }

        protected ExternalSegmentBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("ExternalSegment", nr)), smBuilder);
            this.nameCounter = 0;
            this.descriptionCounter = 0;
            this.recordCountCounter = 0;
            this.startTimeCounter = 0;
            this.endTimeCounter = 0;
            this.durationCounter = 0;
            this.samplingIntervalCounter = 0;
            this.samplingRateCounter = 0;
            this.stateCounter = 0;
            this.lastUpdateCounter = 0;
            this.fileCounter = 0;
            this.blobCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segments/ExternalSegment/1/1"));
        }

        public ExternalSegmentBuilder setName(LangString ... name) {
            if (name.length > 0) {
                ++this.nameCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), TimeSeriesBuilder.this.createMultiLanguageProperties, "Name", IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/Name/1/1"), name);
            return this;
        }

        public ExternalSegmentBuilder setDescription(LangString ... description) {
            if (description.length > 0) {
                ++this.descriptionCounter;
            }
            Utils.createMultiLanguageProperty(this.getDelegate(), TimeSeriesBuilder.this.createMultiLanguageProperties, "Description", IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/Description/1/1"), description);
            return this;
        }

        public ExternalSegmentBuilder setRecordCount(long recordCount) {
            ++this.recordCountCounter;
            this.createPropertyBuilder("RecordCount").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/RecordCount/1/1")).setValue(Type.INT64, recordCount).build();
            return this;
        }

        public ExternalSegmentBuilder setStartTime(Date startTime) {
            ++this.startTimeCounter;
            this.createPropertyBuilder("StartTime").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/StartTime/1/1")).setValue(Type.DATE_TIME, startTime).build();
            return this;
        }

        public ExternalSegmentBuilder setEndTime(Date endTime) {
            ++this.endTimeCounter;
            this.createPropertyBuilder("EndTime").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/EndTime/1/1")).setValue(Type.DATE_TIME, endTime).build();
            return this;
        }

        public ExternalSegmentBuilder setDuration(String duration) {
            ++this.durationCounter;
            this.createPropertyBuilder("Duration").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/Duration/1/1")).setValue(Type.STRING, duration).build();
            return this;
        }

        public ExternalSegmentBuilder setSamplingInterval(long samplingInterval) {
            ++this.samplingIntervalCounter;
            this.createPropertyBuilder("SamplingInterval").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/SamplingInterval/1/1")).setValue(Type.INT64, samplingInterval).build();
            return this;
        }

        public ExternalSegmentBuilder setSamplingRate(long samplingRate) {
            ++this.samplingRateCounter;
            this.createPropertyBuilder("SamplingRate").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/SamplingRate/1/1")).setValue(Type.INT64, samplingRate).build();
            return this;
        }

        public ExternalSegmentBuilder setState(State state) {
            ++this.stateCounter;
            this.createPropertyBuilder("State").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/State/1/1")).setValue(Type.STRING, state.getValue()).build();
            return this;
        }

        public ExternalSegmentBuilder setLastUpdate(Date lastUpdate) {
            ++this.lastUpdateCounter;
            this.createPropertyBuilder("LastUpdate").setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Segment/LastUpdate/1/1")).setValue(Type.DATE_TIME, lastUpdate).build();
            return this;
        }

        public ExternalSegmentBuilder setFile(String file, String mimeType) {
            ++this.fileCounter;
            this.createFileDataElementBuilder("File", file, mimeType).setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/File/1/1")).build();
            return this;
        }

        public ExternalSegmentBuilder setBlob(String file, String mimeType) {
            ++this.blobCounter;
            this.createBlobDataElementBuilder("Blob", file, mimeType).setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Blob/1/1")).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(0 <= this.nameCounter && this.nameCounter <= 1, "Cardinality {} of Name must be greater or equal 0 and less or equal 1.", this.nameCounter);
            Utils.assertThat(0 <= this.descriptionCounter && this.descriptionCounter <= 1, "Cardinality {} of Description must be greater or equal 0 and less or equal 1.", this.descriptionCounter);
            Utils.assertThat(0 <= this.recordCountCounter && this.recordCountCounter <= 1, "Cardinality {} of RecordCount must be greater or equal 0 and less or equal 1.", this.recordCountCounter);
            Utils.assertThat(0 <= this.startTimeCounter && this.startTimeCounter <= 1, "Cardinality {} of StartTime must be greater or equal 0 and less or equal 1.", this.startTimeCounter);
            Utils.assertThat(0 <= this.endTimeCounter && this.endTimeCounter <= 1, "Cardinality {} of EndTime must be greater or equal 0 and less or equal 1.", this.endTimeCounter);
            Utils.assertThat(0 <= this.durationCounter && this.durationCounter <= 1, "Cardinality {} of Duration must be greater or equal 0 and less or equal 1.", this.durationCounter);
            Utils.assertThat(0 <= this.samplingIntervalCounter && this.samplingIntervalCounter <= 1, "Cardinality {} of SamplingInterval must be greater or equal 0 and less or equal 1.", this.samplingIntervalCounter);
            Utils.assertThat(0 <= this.samplingRateCounter && this.samplingRateCounter <= 1, "Cardinality {} of SamplingRate must be greater or equal 0 and less or equal 1.", this.samplingRateCounter);
            Utils.assertThat(0 <= this.stateCounter && this.stateCounter <= 1, "Cardinality {} of State must be greater or equal 0 and less or equal 1.", this.stateCounter);
            Utils.assertThat(0 <= this.lastUpdateCounter && this.lastUpdateCounter <= 1, "Cardinality {} of LastUpdate must be greater or equal 0 and less or equal 1.", this.lastUpdateCounter);
            Utils.assertThat(0 <= this.fileCounter && this.fileCounter <= 1, "Cardinality {} of File must be greater or equal 0 and less or equal 1.", this.fileCounter);
            Utils.assertThat(0 <= this.blobCounter && this.blobCounter <= 1, "Cardinality {} of Blob must be greater or equal 0 and less or equal 1.", this.blobCounter);
            return super.build();
        }
    }

    public class RecordBuilder
    extends DelegatingSubmodelElementCollectionBuilder {
        private int timeCounter;

        protected RecordBuilder(DelegatingSubmodelElementContainerBuilder smBuilder) {
            super(smBuilder.createSubmodelElementCollectionBuilder("Record"), smBuilder);
            this.timeCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Record/1/1"));
        }

        protected RecordBuilder(DelegatingSubmodelElementContainerBuilder smBuilder, int nr) {
            super(smBuilder.createSubmodelElementCollectionBuilder(Utils.getCountingIdShort("Record", nr)), smBuilder);
            this.timeCounter = 0;
            this.setSemanticId(IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/Record/1/1"));
        }

        public RecordBuilder setTime(String time, String semanticId) {
            this.createPropertyBuilder(Utils.getCountingIdShort("Time", ++this.timeCounter)).setSemanticId(semanticId != null && semanticId.length() > 0 ? semanticId : IdentifierType.iri("https://admin-shell.io/idta/TimeSeries/UtcTime/1/1")).setValue(Type.STRING, time).build();
            return this;
        }

        @Override
        public SubmodelElementCollection build() {
            Utils.assertThat(1 <= this.timeCounter, "Cardinality {} of Time must be greater or equal 1.", this.timeCounter);
            return super.build();
        }
    }

    public static enum State {
        IN_PROGRESS(0, IdentifierType.iri("https://admin- shell.io/idta/TimeSeries/Segment/State/InProgress/1/1"), "in progress"),
        COMPLETED(0, IdentifierType.iri("https://admin- shell.io/idta/TimeSeries/Segment/State/Completed/1/1"), "completed");

        private int valueId;
        private String semanticId;
        private String value;

        private State(int valueId, String semanticId, String value) {
            this.valueId = valueId;
            this.semanticId = semanticId;
            this.value = value;
        }

        public int getValueId() {
            return this.valueId;
        }

        public String getSemanticId() {
            return this.semanticId;
        }

        public String getValue() {
            return this.value;
        }
    }
}

