/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.net;

import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.AbstractNetworkManagerImpl;
import de.iip_ecosphere.platform.support.net.ManagedServerAddress;
import de.iip_ecosphere.platform.support.net.NetworkManager;
import de.iip_ecosphere.platform.support.net.NetworkManagerDescriptor;
import de.iip_ecosphere.platform.support.net.NetworkManagerSetup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public class LocalNetworkManagerImpl
extends AbstractNetworkManagerImpl {
    private Map<String, ServerAddress> keyToAddress = new HashMap<String, ServerAddress>();
    private Map<Integer, String> portToKey = new HashMap<Integer, String>();
    private Map<String, Map<String, Integer>> instances = new HashMap<String, Map<String, Integer>>();
    private String host;
    private transient NetworkManager parent;

    public LocalNetworkManagerImpl() {
        this.host = NetUtils.getOwnIP((String)this.getNetmask());
    }

    public LocalNetworkManagerImpl(NetworkManager parent) {
        this.parent = parent;
        this.host = NetUtils.getOwnIP((String)this.getNetmask());
    }

    @Override
    public synchronized ManagedServerAddress obtainPort(String key) {
        ManagedServerAddress result = this.getPort(key);
        if (null == result) {
            do {
                int port;
                if (!this.portToKey.containsKey(port = NetUtils.getEphemeralPort())) {
                    ServerAddress address = new ServerAddress(Schema.IGNORE, this.host, port);
                    this.keyToAddress.put(key, address);
                    this.portToKey.put(port, key);
                    result = new ManagedServerAddress(address, true);
                    LoggerFactory.getLogger(LocalNetworkManagerImpl.class).info("Allocated port " + key + " " + port);
                    this.notifyChanged();
                    continue;
                }
                result = null;
            } while (result == null);
        }
        return result;
    }

    @Override
    public ManagedServerAddress getPort(String key) {
        LocalNetworkManagerImpl.checkKey(key);
        ManagedServerAddress ex = null;
        if (null != this.parent) {
            ex = this.parent.getPort(key);
        }
        if (null == ex) {
            int pos = key.lastIndexOf(".");
            while (pos > 0 && null == ex) {
                String sub = key.substring(0, pos + 1);
                ex = this.keyToAddress.get(sub);
                pos = key.lastIndexOf(".", pos - 1);
            }
        }
        if (null == ex) {
            ex = this.keyToAddress.get(key);
        }
        ManagedServerAddress result = null;
        if (null != ex) {
            result = new ManagedServerAddress(ex, false);
        }
        return result;
    }

    @Override
    public ManagedServerAddress reserveGlobalPort(String key, ServerAddress address) {
        ManagedServerAddress result = this.parent != null ? this.parent.reserveGlobalPort(key, address) : this.reservePort(key, address);
        return result;
    }

    @Override
    public ManagedServerAddress reservePort(String key, ServerAddress address) {
        LocalNetworkManagerImpl.checkAddress(address);
        ManagedServerAddress result = this.getPort(key);
        if (null == result) {
            this.keyToAddress.put(key, address);
            this.portToKey.put(address.getPort(), key);
            result = new ManagedServerAddress(address, true);
            LoggerFactory.getLogger(LocalNetworkManagerImpl.class).info("Reserved port " + key + " " + address.getHost() + " " + address.getPort());
            this.notifyChanged();
        }
        return result;
    }

    @Override
    public synchronized void releasePort(String key) {
        LocalNetworkManagerImpl.checkKey(key);
        ServerAddress ex = this.keyToAddress.remove(key);
        if (null != ex) {
            this.portToKey.remove(ex.getPort());
            LoggerFactory.getLogger(LocalNetworkManagerImpl.class).info("Released port " + key);
            this.notifyChanged();
        } else if (this.parent != null) {
            this.parent.releasePort(key);
        }
    }

    @Override
    public synchronized boolean isInUse(int port) {
        return this.portToKey.containsKey(port);
    }

    @Override
    public boolean isInUse(ServerAddress adr) {
        LocalNetworkManagerImpl.checkAddress(adr);
        return this.host.equals(adr.getHost()) && this.isInUse(adr.getPort());
    }

    @Override
    public void configure(NetworkManagerSetup setup) {
        super.configure(setup);
        if (null != setup) {
            this.host = NetUtils.getOwnIP((String)this.getNetmask());
        }
    }

    @Override
    public synchronized void registerInstance(String key, String hostId) {
        if (null != key && null != hostId) {
            Integer count;
            Map<String, Integer> inst = this.instances.get(key);
            if (null == inst) {
                inst = new HashMap<String, Integer>();
                this.instances.put(key, inst);
            }
            if (null == (count = inst.get(hostId))) {
                count = 1;
            } else {
                Integer n = count;
                count = count + 1;
            }
            inst.put(hostId, count);
            this.notifyChanged();
        }
    }

    @Override
    public synchronized void unregisterInstance(String key, String hostId) {
        Map<String, Integer> inst;
        if (null != key && null != hostId && (inst = this.instances.get(key)) != null) {
            Integer count = inst.get(hostId);
            if (count != null) {
                Integer n = count;
                count = count - 1;
                if (count == 0) {
                    inst.remove(hostId);
                } else {
                    inst.put(hostId, count);
                }
            }
            if (inst.isEmpty()) {
                this.instances.remove(key);
                this.notifyChanged();
            }
        }
    }

    @Override
    public synchronized int getRegisteredInstances(String key) {
        Map<String, Integer> inst;
        int result = 0;
        if (null != key && null != (inst = this.instances.get(key))) {
            for (Map.Entry<String, Integer> e : inst.entrySet()) {
                result += e.getValue().intValue();
            }
        }
        return result;
    }

    protected void notifyChanged() {
    }

    public void writeTo(ObjectOutputStream out) throws IOException {
        out.writeObject(this.keyToAddress);
        out.writeObject(this.portToKey);
        out.writeObject(this.instances);
        out.writeUTF(this.host);
    }

    public void readFrom(ObjectInputStream in) throws IOException {
        try {
            this.keyToAddress = (Map)in.readObject();
            this.portToKey = (Map)in.readObject();
            this.instances = (Map)in.readObject();
            this.host = in.readUTF();
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static class Descriptor
    implements NetworkManagerDescriptor {
        @Override
        public NetworkManager createInstance() {
            return new LocalNetworkManagerImpl();
        }
    }
}

