/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jsensors;

import com.profesorfalken.jsensors.SensorsConfig;
import com.profesorfalken.jsensors.SensorsLocator;
import com.profesorfalken.jsensors.manager.windows.powershell.PowerShellOperations;
import com.profesorfalken.jsensors.model.components.Components;
import com.profesorfalken.jsensors.standalone.ConsoleOutput;
import com.profesorfalken.jsensors.standalone.GuiOutput;
import com.profesorfalken.jsensors.util.OSDetector;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum JSensors {
    get;

    private static final Logger LOGGER;
    final Map<String, String> baseConfig = SensorsConfig.getConfigMap();
    private Map<String, String> usedConfig = null;

    private static void checkRights() {
        if (OSDetector.isWindows() && !PowerShellOperations.isAdministrator()) {
            LOGGER.warn("You have not executed jSensors in Administrator mode, so CPU temperature sensors will not be detected.");
        }
    }

    public JSensors config(Map<String, String> config) {
        if (this.usedConfig == null) {
            this.usedConfig = this.baseConfig;
        }
        for (Map.Entry<String, String> entry : config.entrySet()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Overriding config entry %s, %s by %s", entry.getKey(), this.usedConfig.get(entry.getKey()), entry.getValue()));
            }
            this.usedConfig.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Components components() {
        if (this.usedConfig == null) {
            this.usedConfig = new HashMap<String, String>();
        }
        Components components = SensorsLocator.get.getComponents(this.usedConfig);
        this.usedConfig = this.baseConfig;
        return components;
    }

    public static void main(String[] args) {
        boolean guiMode = false;
        HashMap<String, String> overriddenConfig = new HashMap<String, String>();
        for (String arg : args) {
            if ("--debug".equals(arg)) {
                overriddenConfig.put("debugMode", "true");
            }
            if (!"--gui".equals(arg)) continue;
            guiMode = true;
        }
        if (guiMode) {
            GuiOutput.showOutput(overriddenConfig);
        } else {
            ConsoleOutput.showOutput(overriddenConfig);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(JSensors.class);
        JSensors.checkRights();
    }
}

