/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.net;

import de.iip_ecosphere.platform.support.identities.IdentityStore;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class KeyStoreDescriptor
implements Serializable {
    private static final long serialVersionUID = 8475063607431932314L;
    private File path;
    private String password;
    private String alias;
    private boolean appliesToClient = true;
    private boolean hostNameVerification = true;

    public KeyStoreDescriptor(File path, String password, String alias) {
        this(path, password, alias, true, true);
    }

    public KeyStoreDescriptor(File path, String password, String alias, boolean appliesToClient, boolean hostNameVerification) {
        this.path = path;
        this.password = password;
        this.alias = alias;
        this.hostNameVerification = true;
        this.appliesToClient = true;
    }

    public KeyStoreDescriptor(IdentityStore.KeystoreCoordinate keystore, String alias, boolean appliesToClient, boolean hostNameVerification) {
        this(new File(keystore.getPassword()), keystore.getPassword(), alias, appliesToClient, hostNameVerification);
    }

    public static KeyStoreDescriptor create(String keystoreKey, String alias, boolean appliesToClient, boolean hostNameVerification) throws IOException {
        IdentityStore.KeystoreCoordinate keystore = IdentityStore.getInstance().getKeystoreCoordinate(keystoreKey, new String[0]);
        if (null == keystore) {
            throw new IOException("Keystore with key '" + keystoreKey + "' not found.");
        }
        return new KeyStoreDescriptor(keystore, alias, appliesToClient, hostNameVerification);
    }

    public File getPath() {
        return this.path;
    }

    public String getAbsolutePath() {
        String result = null;
        if (null != this.path) {
            try {
                result = this.path.getCanonicalFile().getAbsolutePath();
            }
            catch (IOException e) {
                result = this.path.getAbsolutePath();
            }
        }
        return result;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean appliesToClient() {
        return this.appliesToClient;
    }

    public boolean applyHostnameVerification() {
        return this.hostNameVerification;
    }
}

