/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.dfltSysMetrics;

import com.profesorfalken.jsensors.JSensors;
import com.profesorfalken.jsensors.model.components.Components;
import com.profesorfalken.jsensors.model.components.Cpu;
import com.profesorfalken.jsensors.model.sensors.Temperature;
import de.iip_ecosphere.platform.support.OsUtils;
import de.iip_ecosphere.platform.support.metrics.SystemMetrics;

public class DefaultSystemMetrics
implements SystemMetrics {
    public static final SystemMetrics INSTANCE = new DefaultSystemMetrics();
    private Components components = JSensors.get.components();

    protected DefaultSystemMetrics() {
    }

    public float getCaseTemperature() {
        return -274.0f;
    }

    public float getCpuTemperature() {
        float result = 0.0f;
        float count = 0.0f;
        if (this.components.cpus != null) {
            for (Cpu cpu : this.components.cpus) {
                if (cpu.sensors == null) continue;
                for (Temperature tmp : cpu.sensors.temperatures) {
                    result = (float)((double)result + tmp.value);
                }
            }
        }
        return count == 0.0f ? -274.0f : result / count;
    }

    public int getNumGpuCores() {
        return null != this.components.gpus ? this.components.gpus.size() : 0;
    }

    public int getNumCpuCores() {
        return null != this.components.cpus ? this.components.cpus.size() : OsUtils.getNumCpuCores();
    }
}

