/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.http.apache;

import de.iip_ecosphere.platform.support.http.Http;
import de.iip_ecosphere.platform.support.http.HttpClient;
import de.iip_ecosphere.platform.support.http.HttpRequest;
import de.iip_ecosphere.platform.support.http.HttpResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class ApacheHttp
extends Http {
    public de.iip_ecosphere.platform.support.http.HttpPost createPost(String uri) {
        return new ApacheHttpPost(uri);
    }

    public HttpClient createClient() {
        return new ApacheHttpClient(HttpClients.createDefault());
    }

    public HttpClient createPooledClient() {
        PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager();
        return new ApacheHttpClient(HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingConnectionManager).build());
    }

    private class ApacheHttpPost
    extends ApacheHttpUriRequest<HttpPost, de.iip_ecosphere.platform.support.http.HttpPost>
    implements de.iip_ecosphere.platform.support.http.HttpPost {
        private ApacheHttpPost(String uri) {
            super(ApacheHttp.this, (HttpUriRequest)new HttpPost(uri));
        }

        public de.iip_ecosphere.platform.support.http.HttpPost setEntity(String entity) throws IOException {
            try {
                ((HttpPost)this.getRequest()).setEntity((HttpEntity)new StringEntity(entity));
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException(e);
            }
            return this;
        }
    }

    private class ApacheHttpClient
    implements HttpClient {
        private CloseableHttpClient client;

        private ApacheHttpClient(CloseableHttpClient client) {
            this.client = client;
        }

        public HttpResponse execute(HttpRequest<?> request) throws IOException {
            return new ApacheHttpResponse(this.client.execute(((ApacheHttpUriRequest)request).getRequest()));
        }

        public void close() throws IOException {
            this.client.close();
        }
    }

    private class ApacheHttpResponse
    implements HttpResponse {
        private CloseableHttpResponse response;

        private ApacheHttpResponse(CloseableHttpResponse response) {
            this.response = response;
        }

        public String getEntityAsString() throws IOException {
            return EntityUtils.toString((HttpEntity)this.response.getEntity());
        }

        public int getStatusCode() {
            return this.response.getStatusLine().getStatusCode();
        }

        public String getReasonPhrase() {
            return this.response.getStatusLine().getReasonPhrase();
        }

        public void close() throws IOException {
            this.response.close();
        }
    }

    private static abstract class ApacheHttpUriRequest<R extends HttpUriRequest, S extends HttpRequest<S>>
    implements HttpRequest<S> {
        private R request;
        final /* synthetic */ ApacheHttp this$0;

        protected ApacheHttpUriRequest(R request) {
            this.this$0 = var1_1;
            this.request = request;
        }

        public S setHeader(String name, String value) {
            this.request.setHeader(name, value);
            return (S)this;
        }

        protected R getRequest() {
            return this.request;
        }
    }
}

