/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class IipVersion {
    public static final String MAVEN_SNAPSHOT_POSTFIX = "-SNAPSHOT";
    private static IipVersion instance;
    private String version = "";
    private String buildId = "??";
    private boolean isRelease = false;

    private IipVersion() {
        InputStream is = ResourceLoader.getResourceAsStream((String)"iip-version.properties", (ResourceResolver[])new ResourceResolver[0]);
        if (null != is) {
            Properties prop = new Properties();
            try {
                prop.load(is);
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.version = prop.getOrDefault((Object)"version", this.version).toString();
            if (this.version.endsWith(MAVEN_SNAPSHOT_POSTFIX)) {
                this.version = this.version.substring(0, this.version.length() - MAVEN_SNAPSHOT_POSTFIX.length());
            } else {
                this.isRelease = true;
            }
            this.buildId = prop.getOrDefault((Object)"buildId", this.buildId).toString();
        }
    }

    public static IipVersion getInstance() {
        if (null == instance) {
            instance = new IipVersion();
        }
        return instance;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public boolean isBuildIdSet() {
        return !this.buildId.equals("??");
    }

    public boolean isRelease() {
        return this.isRelease;
    }

    public String getVersionInfo() {
        Object result = this.version.length() == 0 ? "??" : "v " + this.version + "(" + this.buildId + ")";
        return result;
    }
}

