/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.TaskRegistry;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;

public class ActiveAasBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveAasBase.class);
    private static NotificationMode mode = NotificationMode.ASYNCHRONOUS;
    private static ExecutorService exec = Executors.newFixedThreadPool(5);

    public static void processNotification(String subId, NotificationProcessor processor) {
        ActiveAasBase.processNotification(subId, mode, processor);
    }

    public static void processNotification(String subId, NotificationMode mode, NotificationProcessor processor) {
        if (ActiveAasBase.mode != NotificationMode.NONE) {
            if (null == mode) {
                mode = ActiveAasBase.mode;
            }
            try {
                Aas aas = AasPartRegistry.retrieveIipAas();
                if (null != aas) {
                    Submodel submodel = aas.getSubmodel(subId);
                    if (null != submodel) {
                        if (NotificationMode.SYNCHRONOUS == mode) {
                            processor.process(submodel, aas);
                        } else {
                            TaskRegistry.TaskData data = TaskRegistry.getTaskData();
                            exec.execute(() -> {
                                TaskRegistry.associateTask(null, (TaskRegistry.TaskData)data);
                                processor.process(submodel, aas);
                                TaskRegistry.unassociateTask(null);
                            });
                        }
                    }
                } else if (!AasFactory.isNoInstanceWarningEmitted()) {
                    LOGGER.error("Cannot find submodel: " + subId);
                }
            }
            catch (IOException e) {
                LOGGER.error("While retrieving the IIP-Ecosphere AAS: " + e.getMessage());
            }
        }
    }

    public static NotificationMode setNotificationMode(NotificationMode mo) {
        NotificationMode old = mode;
        mode = mo;
        return old;
    }

    public static Submodel getSubmodel(String name) throws IOException {
        Aas aas = AasPartRegistry.retrieveIipAas();
        if (null == aas) {
            throw new IOException("No IIP-AAS found");
        }
        Submodel submodel = aas.getSubmodel(name);
        if (null == submodel) {
            throw new IOException("No submodel '" + name + "' found");
        }
        return submodel;
    }

    public static void clearCollection(SubmodelElementCollection coll, Predicate<SubmodelElementCollection> pred) {
        if (null != coll) {
            for (SubmodelElement e : coll.elements()) {
                SubmodelElementCollection ec;
                if (!(e instanceof SubmodelElementCollection) || !pred.test(ec = (SubmodelElementCollection)e)) continue;
                coll.deleteElement(e.getIdShort());
            }
        }
    }

    public static Predicate<SubmodelElementCollection> createPropertyPredicate(String propertyIdShort, Object propertyValue, String failMessage) {
        return s -> {
            boolean result = false;
            try {
                Property prop = s.getProperty(propertyIdShort);
                if (null != prop && propertyValue.equals(prop.getValue())) {
                    result = true;
                }
            }
            catch (ExecutionException ex) {
                LoggerFactory.getLogger(ActiveAasBase.class).error("{}: {} ", (Object)failMessage, (Object)ex.getMessage());
            }
            return result;
        };
    }

    public static enum NotificationMode {
        ASYNCHRONOUS,
        SYNCHRONOUS,
        NONE;

    }

    public static interface NotificationProcessor {
        public void process(Submodel var1, Aas var2);
    }
}

