/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.support.semanticId.DefaultSemanticIdResolutionResult;
import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolutionResult;
import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolver;
import de.iip_ecosphere.platform.support.setup.AbstractSetup;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class YamlSemanticCatalog {
    private List<DefaultSemanticIdResolutionResult> definitions = new ArrayList<DefaultSemanticIdResolutionResult>();

    public List<DefaultSemanticIdResolutionResult> getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(List<DefaultSemanticIdResolutionResult> definitions) {
        this.definitions = definitions;
    }

    public static YamlSemanticCatalog read(InputStream input) throws IOException {
        return (YamlSemanticCatalog)AbstractSetup.readFromYaml(YamlSemanticCatalog.class, (InputStream)input);
    }

    public static YamlSemanticCatalog readSafe(InputStream input) {
        try {
            return YamlSemanticCatalog.read(input);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(YamlSemanticCatalog.class).warn("Cannot read catalog from input stream: {}. Falling back to empty catalog.", (Object)e.getMessage());
            return new YamlSemanticCatalog();
        }
    }

    public static Map<String, SemanticIdResolutionResult> toMap(YamlSemanticCatalog catalog, Function<DefaultSemanticIdResolutionResult, DefaultSemanticIdResolutionResult> adjuster) {
        HashMap<String, SemanticIdResolutionResult> result = new HashMap<String, SemanticIdResolutionResult>();
        if (null != catalog) {
            for (DefaultSemanticIdResolutionResult r : catalog.getDefinitions()) {
                if (null != adjuster) {
                    r = adjuster.apply(r);
                }
                result.put(r.getSemanticId(), (SemanticIdResolutionResult)r);
            }
        }
        return result;
    }

    public static class YamlBasedResolver
    extends SemanticIdResolver {
        private String name;
        private Map<String, SemanticIdResolutionResult> catalog;
        private Predicate<String> responsible;

        public YamlBasedResolver(String name, String resource, Predicate<String> responsible, Function<DefaultSemanticIdResolutionResult, DefaultSemanticIdResolutionResult> adjuster) {
            this(name, YamlSemanticCatalog.readSafe(ResourceLoader.getResourceAsStream((String)resource, (ResourceResolver[])new ResourceResolver[0])), responsible, adjuster);
        }

        public YamlBasedResolver(String name, YamlSemanticCatalog catalog, Predicate<String> responsible, Function<DefaultSemanticIdResolutionResult, DefaultSemanticIdResolutionResult> adjuster) {
            this.catalog = YamlSemanticCatalog.toMap(catalog, adjuster);
            this.responsible = responsible;
            this.name = null == name || name.length() == 0 ? ((Object)((Object)this)).getClass().getName() : name;
        }

        public String getName() {
            return this.name;
        }

        public SemanticIdResolutionResult resolveSemanticId(String semanticId) {
            return this.catalog.get(semanticId);
        }

        public boolean isResponsible(String semanticId) {
            return this.responsible.test(semanticId);
        }
    }
}

