/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.iip_aas.config.EndpointHolder;
import de.iip_ecosphere.platform.support.iip_aas.config.RuntimeSetup;
import de.iip_ecosphere.platform.support.iip_aas.config.RuntimeSetupEndpointValidator;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class EndpointHolderTest {
    @Test
    public void testEndpointHolder() {
        File file = RuntimeSetup.getFile();
        FileUtils.deleteQuietly((File)file);
        RuntimeSetup setup = new RuntimeSetup();
        setup.setAasRegistry("https://me.here.de:9998/myPath");
        setup.store();
        EndpointHolder holder = new EndpointHolder(Schema.HTTP, "localhost", -1, "path");
        Assert.assertEquals((Object)holder.getSchema(), (Object)Schema.HTTP);
        Assert.assertEquals((Object)holder.getHost(), (Object)"localhost");
        Assert.assertEquals((long)holder.getPort(), (long)-1L);
        Assert.assertEquals((Object)holder.getPath(), (Object)"path");
        holder.setValidator(RuntimeSetupEndpointValidator.create(r -> r.getAasRegistry()));
        Assert.assertEquals((Object)holder.getSchema(), (Object)Schema.HTTPS);
        Assert.assertEquals((Object)holder.getHost(), (Object)"me.here.de");
        Assert.assertEquals((long)holder.getPort(), (long)9998L);
        Assert.assertEquals((Object)holder.getPath(), (Object)"myPath");
        FileUtils.deleteQuietly((File)file);
        RuntimeSetup.clear();
    }
}

