/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.iip_aas.NameplateSetup;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class NameplateSetupTest {
    @Test
    public void testNameplateSetup() throws IOException {
        NameplateSetup init = NameplateSetup.obtainNameplateSetup();
        Aas aas = init.createAas("urn:::AAS:::a1234#", "a1234", a -> {});
        NameplateSetup setup = NameplateSetup.readFromAas((Aas)aas);
        Assert.assertNotNull((Object)setup);
        Assert.assertNotNull((Object)setup.getServices());
        Map services = NameplateSetup.getServicesAsMap((List)setup.getServices());
        Assert.assertEquals((long)2L, (long)services.size());
        NameplateSetup.Service s = (NameplateSetup.Service)services.get("opcua");
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((Object)"opcua", (Object)s.getKey());
        Assert.assertEquals((long)4840L, (long)s.getPort());
        Assert.assertTrue((s.getHost().length() > 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)s.getNetmask());
        Assert.assertNull((Object)s.getVersion());
        s = (NameplateSetup.Service)services.get("mqtt");
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((Object)"mqtt", (Object)s.getKey());
        Assert.assertEquals((long)1883L, (long)s.getPort());
        Assert.assertTrue((s.getHost().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)s.getNetmask());
        Assert.assertTrue((s.getNetmask().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)s.getVersion());
        Assert.assertEquals((Object)"5", (Object)s.getVersion().toString());
    }

    @Test
    public void testExpandUrn() {
        Assert.assertEquals((Object)"", (Object)NameplateSetup.expandUrn((String)"", (String)"-local"));
        Assert.assertEquals((Object)"aaa", (Object)NameplateSetup.expandUrn((String)"aaa", (String)"-local"));
        Assert.assertEquals((Object)"urn:::AAS:::myDevice-local#", (Object)NameplateSetup.expandUrn((String)"urn:::AAS:::myDevice#", (String)"-local"));
    }
}

