/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolutionResult;
import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolver;
import org.junit.Assert;
import org.junit.Test;

public class YamlSemanticIdResolverDescriptorTest {
    @Test
    public void testEclassYaml() {
        SemanticIdResolutionResult res = SemanticIdResolver.resolve((String)"0173-1#05-AAA114#003");
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)"0173-1#05-AAA114#003", (Object)res.getSemanticId());
        Assert.assertEquals((Object)"IRDI", (Object)res.getKind());
        Assert.assertEquals((Object)"ECLASS", (Object)res.getPublisher());
        Assert.assertTrue((res.getRevision().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getVersion().length() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)res.getNaming().size());
        SemanticIdResolutionResult.Naming naming = (SemanticIdResolutionResult.Naming)res.getNaming().get("de");
        Assert.assertNotNull((Object)naming);
        Assert.assertTrue((naming.getName().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((naming.getDescription().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((naming.getStructuredName().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAdminShellIoYaml() {
        SemanticIdResolutionResult res = SemanticIdResolver.resolve((String)"https://admin-shell.io/ZVEI/TechnicalData/ProductImage/1/1");
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)"https://admin-shell.io/ZVEI/TechnicalData/ProductImage/1/1", (Object)res.getSemanticId());
        Assert.assertEquals((Object)"IRI", (Object)res.getKind());
        Assert.assertEquals((Object)"ZVEI", (Object)res.getPublisher());
        Assert.assertTrue((res.getRevision().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getVersion().length() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)res.getNaming().size());
        SemanticIdResolutionResult.Naming naming = (SemanticIdResolutionResult.Naming)res.getNaming().get("de");
        Assert.assertNotNull((Object)naming);
        Assert.assertTrue((naming.getName().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((naming.getDescription().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((naming.getStructuredName().length() > 0 ? 1 : 0) != 0);
    }
}

