/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.spi;

import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.TypeLiteral;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public class UnwrapperDescriptor {
    public Method method;
    public boolean isMap;
    public TypeLiteral mapValueTypeLiteral;

    public UnwrapperDescriptor(Method method) {
        this.method = method;
        if (this.isMapUnwrapper(method)) {
            ParameterizedType pType;
            Type[] typeArgs;
            this.isMap = true;
            Type mapType = method.getGenericReturnType();
            this.mapValueTypeLiteral = TypeLiteral.create(Object.class);
            if (mapType instanceof ParameterizedType && (typeArgs = (pType = (ParameterizedType)mapType).getActualTypeArguments()).length == 2) {
                this.mapValueTypeLiteral = TypeLiteral.create(typeArgs[1]);
            }
        } else if (this.isStreamUnwrapper(method)) {
            this.isMap = false;
        } else {
            throw new JsonException("invalid unwrapper method signature: " + method);
        }
    }

    private boolean isMapUnwrapper(Method method) {
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return Map.class.isAssignableFrom(method.getReturnType());
    }

    private boolean isStreamUnwrapper(Method method) {
        if (method.getReturnType() != Void.TYPE) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            return false;
        }
        return parameterTypes[0] == JsonStream.class;
    }
}

