/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.CodegenImplNative;
import com.jsoniter.IterImpl;
import com.jsoniter.JsonIterator;
import com.jsoniter.spi.Decoder;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import java.io.IOException;
import java.lang.reflect.Type;

class MapKeyDecoders {
    MapKeyDecoders() {
    }

    public static Decoder registerOrGetExisting(Type mapKeyType) {
        String cacheKey = JsoniterSpi.getMapKeyDecoderCacheKey(mapKeyType);
        Decoder mapKeyDecoder = JsoniterSpi.getMapKeyDecoder(cacheKey);
        if (null != mapKeyDecoder) {
            return mapKeyDecoder;
        }
        mapKeyDecoder = MapKeyDecoders.createMapKeyDecoder(mapKeyType);
        JsoniterSpi.addNewMapDecoder(cacheKey, mapKeyDecoder);
        return mapKeyDecoder;
    }

    private static Decoder createMapKeyDecoder(Type mapKeyType) {
        if (String.class == mapKeyType) {
            return new StringKeyDecoder();
        }
        if (mapKeyType instanceof Class && ((Class)mapKeyType).isEnum()) {
            return new EnumKeyDecoder((Class)mapKeyType);
        }
        Decoder decoder = CodegenImplNative.NATIVE_DECODERS.get(mapKeyType);
        if (decoder != null) {
            return new NumberKeyDecoder(decoder);
        }
        throw new JsonException("can not decode map key type: " + mapKeyType);
    }

    private static class NumberKeyDecoder
    implements Decoder {
        private final Decoder decoder;

        private NumberKeyDecoder(Decoder decoder) {
            this.decoder = decoder;
        }

        @Override
        public Object decode(JsonIterator iter) throws IOException {
            if (IterImpl.nextToken(iter) != 34) {
                throw iter.reportError("decode number map key", "expect \"");
            }
            Object key = this.decoder.decode(iter);
            if (IterImpl.nextToken(iter) != 34) {
                throw iter.reportError("decode number map key", "expect \"");
            }
            return key;
        }
    }

    private static class EnumKeyDecoder
    implements Decoder {
        private final Class enumClass;

        private EnumKeyDecoder(Class enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        public Object decode(JsonIterator iter) throws IOException {
            return iter.read(this.enumClass);
        }
    }

    private static class StringKeyDecoder
    implements Decoder {
        private StringKeyDecoder() {
        }

        @Override
        public Object decode(JsonIterator iter) throws IOException {
            return iter.readString();
        }
    }
}

