/*
 * Decompiled with CFR 0.152.
 */
package test.de.oktoflow.platform.support.json.jackson;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonArray;
import de.iip_ecosphere.platform.support.json.JsonIterator;
import de.iip_ecosphere.platform.support.json.JsonNumber;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.json.JsonString;
import de.oktoflow.platform.support.json.jackson.JacksonJson;
import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class JsonTest {
    private void assertData(Data value, Data expected) {
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((long)value.getiValue(), (long)expected.getiValue());
        Assert.assertEquals((Object)value.getsValue(), (Object)expected.getsValue());
    }

    @Test
    public void testJson() throws IOException {
        Json json = Json.createInstance();
        Assert.assertTrue((boolean)(json instanceof JacksonJson));
        Data data = new Data();
        data.setiValue(10);
        data.setsValue("abba");
        String s = Json.toJsonDflt((Object)data);
        Data data1 = (Data)Json.fromJsonDflt((Object)s, Data.class);
        this.assertData(data1, data);
        s = json.toJson((Object)data);
        data1 = (Data)json.fromJson((Object)s, Data.class);
        this.assertData(data1, data);
        byte[] b = json.writeValueAsBytes((Object)data);
        data1 = (Data)json.readValue(b, Data.class);
        this.assertData(data1, data);
    }

    @Test
    public void testJsonObject() throws IOException {
        JsonObject jobj = (JsonObject)Json.createObjectBuilder().add("intVal", 1).add("strVal", "abc").add("boolVal", true).add("dblVal", 2.0).add("arr", (JsonArray)Json.createArrayBuilder().add(1).add("str").add(true).add(Json.createArrayBuilder()).build()).build();
        String json = jobj.toString();
        JsonObject obj = Json.createObject((String)json);
        Assert.assertNotNull((Object)obj);
        JsonNumber n1 = obj.getJsonNumber("intVal");
        Assert.assertNotNull((Object)n1);
        Assert.assertEquals((long)1L, (long)n1.intValue());
        JsonNumber n2 = obj.getJsonNumber("dblVal");
        Assert.assertNotNull((Object)n2);
        Assert.assertEquals((double)2.0, (double)n2.intValue(), (double)0.01);
        JsonString s1 = obj.getJsonString("strVal");
        Assert.assertNotNull((Object)s1);
        Assert.assertEquals((Object)"abc", (Object)s1.getString());
        Assert.assertEquals((long)1L, (long)obj.getInt("intVal"));
        Assert.assertEquals((Object)"abc", (Object)obj.getString("strVal"));
        Assert.assertEquals((Object)true, (Object)obj.getBoolean("boolVal"));
        JsonArray a1 = obj.getJsonArray("arr");
        Assert.assertEquals((long)4L, (long)a1.size());
        Assert.assertNotNull((Object)a1);
        Assert.assertEquals((Object)"str", (Object)a1.getString(1));
        Assert.assertEquals((long)1L, (long)a1.getInt(0));
        Assert.assertEquals((Object)true, (Object)a1.getBoolean(2));
        JsonArray a2 = a1.getJsonArray(3);
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((long)0L, (long)a2.size());
    }

    @Test
    public void testJsonIter() throws IOException {
        JsonObject jobj = (JsonObject)Json.createObjectBuilder().add("intVal", 1).add("strVal", "abc").add("boolVal", true).add("dblVal", 2.0).add("arr", (JsonArray)Json.createArrayBuilder().add(1).add("str").add(true).add(Json.createArrayBuilder()).build()).build();
        String json = jobj.toString();
        JsonIterator iter = Json.parse((String)json);
        Assert.assertNotNull((Object)iter.getAnyKey());
        Assert.assertEquals((Object)JsonIterator.ValueType.OBJECT, (Object)iter.valueType());
        Assert.assertEquals((long)5L, (long)iter.size());
        Assert.assertTrue((boolean)iter.containsKey("strVal"));
        Assert.assertFalse((boolean)iter.containsKey("xyz"));
        JsonIterator tmp = iter.get("intVal");
        Assert.assertNotNull((Object)tmp);
        Assert.assertNull((Object)tmp.getAnyKey());
        Assert.assertEquals((Object)JsonIterator.ValueType.NUMBER, (Object)tmp.valueType());
        Assert.assertEquals((long)1L, (long)tmp.toIntValue());
        tmp = iter.get("strVal");
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((Object)JsonIterator.ValueType.STRING, (Object)tmp.valueType());
        Assert.assertEquals((Object)"abc", (Object)tmp.toStringValue());
        tmp = iter.get("boolVal");
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((Object)JsonIterator.ValueType.BOOLEAN, (Object)tmp.valueType());
        Assert.assertEquals((Object)true, (Object)tmp.toBooleanValue());
        tmp = iter.get("dblVal");
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((Object)JsonIterator.ValueType.NUMBER, (Object)tmp.valueType());
        Assert.assertEquals((double)2.0, (double)tmp.toDoubleValue(), (double)0.01);
        Assert.assertEquals((double)2.0, (double)tmp.toFloatValue(), (double)0.01);
        tmp = iter.get("arr");
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((Object)JsonIterator.ValueType.ARRAY, (Object)tmp.valueType());
        JsonIterator arrTmp = tmp.get(0);
        Assert.assertNotNull((Object)arrTmp);
        Assert.assertEquals((Object)JsonIterator.ValueType.NUMBER, (Object)arrTmp.valueType());
        iter = Json.parse((String)json);
        JsonIterator.EntryIterator eIter = iter.entries();
        HashMap<String, JsonIterator> entries = new HashMap<String, JsonIterator>();
        while (eIter.next()) {
            entries.put(eIter.key(), eIter.value());
        }
        Assert.assertEquals((long)5L, (long)entries.size());
        Assert.assertTrue((boolean)entries.containsKey("arr"));
        byte[] data = json.getBytes();
        iter = Json.parse((byte[])data);
        tmp = iter.get("arr");
        Assert.assertNotNull((Object)tmp);
        byte[] tmpData = iter.slice(data, tmp);
        Assert.assertNotNull((Object)tmpData);
        Assert.assertTrue((tmpData.length < data.length ? 1 : 0) != 0);
        String tmpStr = new String(tmpData);
        Assert.assertTrue((tmpStr.startsWith("[") && tmpStr.endsWith("]") ? 1 : 0) != 0);
    }

    public static class Data {
        private int iValue;
        private String sValue;

        public int getiValue() {
            return this.iValue;
        }

        public void setiValue(int iValue) {
            this.iValue = iValue;
        }

        public String getsValue() {
            return this.sValue;
        }

        public void setsValue(String sValue) {
            this.sValue = sValue;
        }
    }
}

