/*
 * Decompiled with CFR 0.152.
 */
package test.de.oktoflow.platform.support.json.jackson;

import de.iip_ecosphere.platform.support.Filter;
import de.iip_ecosphere.platform.support.IgnoreProperties;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonArray;
import de.iip_ecosphere.platform.support.json.JsonGenerator;
import de.iip_ecosphere.platform.support.json.JsonIterator;
import de.iip_ecosphere.platform.support.json.JsonNumber;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.json.JsonString;
import de.oktoflow.platform.support.json.jackson.JacksonJson;
import iip.datatypes.DataImpl;
import iip.datatypes.RoutingCommandNew;
import iip.datatypes.RoutingCommandNewImpl;
import iip.datatypes.RoutingCommandOld;
import iip.datatypes.RoutingCommandOldImpl;
import iip.serializers.RoutingCommandNewImplSerializer;
import iip.serializers.RoutingCommandNewSerializer;
import iip.serializers.RoutingCommandOldImplSerializer;
import iip.serializers.RoutingCommandOldSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class JsonTest {
    public static final String FILTER_ID_DATA = "dataFilter";

    private void assertData(Data value, Data expected) {
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((long)value.getiValue(), (long)expected.getiValue());
        Assert.assertEquals((Object)value.getsValue(), (Object)expected.getsValue());
    }

    @Test
    public void testJson() throws IOException {
        Json json = Json.createInstance();
        Assert.assertTrue((boolean)(json instanceof JacksonJson));
        Data data = new Data();
        data.setiValue(10);
        data.setsValue("abba");
        String s = Json.toJsonDflt((Object)data);
        Data data1 = (Data)Json.fromJsonDflt((Object)s, Data.class);
        this.assertData(data1, data);
        s = json.toJson((Object)data);
        data1 = (Data)json.fromJson((Object)s, Data.class);
        this.assertData(data1, data);
        byte[] b = json.writeValueAsBytes((Object)data);
        data1 = (Data)json.readValue(b, Data.class);
        this.assertData(data1, data);
    }

    @Test
    public void testJsonObject() throws IOException {
        JsonObject jobj = (JsonObject)Json.createObjectBuilder().add("intVal", 1).add("strVal", "abc").add("boolVal", true).add("dblVal", 2.0).add("arr", (JsonArray)Json.createArrayBuilder().add(1).add("str").add(true).add(Json.createArrayBuilder()).build()).build();
        String json = jobj.toString();
        JsonObject obj = Json.createObject((String)json);
        Assert.assertNotNull((Object)obj);
        JsonNumber n1 = obj.getJsonNumber("intVal");
        Assert.assertNotNull((Object)n1);
        Assert.assertEquals((long)1L, (long)n1.intValue());
        JsonNumber n2 = obj.getJsonNumber("dblVal");
        Assert.assertNotNull((Object)n2);
        Assert.assertEquals((double)2.0, (double)n2.intValue(), (double)0.01);
        JsonString s1 = obj.getJsonString("strVal");
        Assert.assertNotNull((Object)s1);
        Assert.assertEquals((Object)"abc", (Object)s1.getString());
        Assert.assertEquals((long)1L, (long)obj.getInt("intVal"));
        Assert.assertEquals((Object)"abc", (Object)obj.getString("strVal"));
        Assert.assertEquals((Object)true, (Object)obj.getBoolean("boolVal"));
        JsonArray a1 = obj.getJsonArray("arr");
        Assert.assertEquals((long)4L, (long)a1.size());
        Assert.assertNotNull((Object)a1);
        Assert.assertEquals((Object)"str", (Object)a1.getString(1));
        Assert.assertEquals((long)1L, (long)a1.getInt(0));
        Assert.assertEquals((Object)true, (Object)a1.getBoolean(2));
        JsonArray a2 = a1.getJsonArray(3);
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((long)0L, (long)a2.size());
    }

    @Test
    public void testJsonIter() throws IOException {
        JsonObject jobj = (JsonObject)Json.createObjectBuilder().add("intVal", 1).add("strVal", "abc").add("boolVal", true).add("dblVal", 2.0).add("arr", (JsonArray)Json.createArrayBuilder().add(1).add("str").add(true).add(Json.createArrayBuilder()).build()).build();
        String json = jobj.toString();
        JsonIterator iter = Json.parse((String)json);
        Assert.assertNotNull((Object)iter.getAnyKey());
        Assert.assertEquals((Object)JsonIterator.ValueType.OBJECT, (Object)iter.valueType());
        Assert.assertEquals((long)5L, (long)iter.size());
        Assert.assertTrue((boolean)iter.containsKey("strVal"));
        Assert.assertFalse((boolean)iter.containsKey("xyz"));
        JsonIterator tmp = iter.get("intVal");
        Assert.assertNotNull((Object)tmp);
        Assert.assertNull((Object)tmp.getAnyKey());
        Assert.assertEquals((Object)JsonIterator.ValueType.NUMBER, (Object)tmp.valueType());
        Assert.assertEquals((long)1L, (long)tmp.toIntValue());
        tmp = iter.get("strVal");
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((Object)JsonIterator.ValueType.STRING, (Object)tmp.valueType());
        Assert.assertEquals((Object)"abc", (Object)tmp.toStringValue());
        tmp = iter.get("boolVal");
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((Object)JsonIterator.ValueType.BOOLEAN, (Object)tmp.valueType());
        Assert.assertEquals((Object)true, (Object)tmp.toBooleanValue());
        tmp = iter.get("dblVal");
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((Object)JsonIterator.ValueType.NUMBER, (Object)tmp.valueType());
        Assert.assertEquals((double)2.0, (double)tmp.toDoubleValue(), (double)0.01);
        Assert.assertEquals((double)2.0, (double)tmp.toFloatValue(), (double)0.01);
        tmp = iter.get("arr");
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((Object)JsonIterator.ValueType.ARRAY, (Object)tmp.valueType());
        JsonIterator arrTmp = tmp.get(0);
        Assert.assertNotNull((Object)arrTmp);
        Assert.assertEquals((Object)JsonIterator.ValueType.NUMBER, (Object)arrTmp.valueType());
        iter = Json.parse((String)json);
        JsonIterator.EntryIterator eIter = iter.entries();
        HashMap<String, JsonIterator> entries = new HashMap<String, JsonIterator>();
        while (eIter.next()) {
            entries.put(eIter.key(), eIter.value());
        }
        Assert.assertEquals((long)5L, (long)entries.size());
        Assert.assertTrue((boolean)entries.containsKey("arr"));
        byte[] data = json.getBytes();
        iter = Json.parse((byte[])data);
        tmp = iter.get("arr");
        Assert.assertNotNull((Object)tmp);
        byte[] tmpData = iter.slice(data, tmp);
        Assert.assertNotNull((Object)tmpData);
        Assert.assertTrue((tmpData.length < data.length ? 1 : 0) != 0);
        String tmpStr = new String(tmpData);
        Assert.assertTrue((tmpStr.startsWith("[") && tmpStr.endsWith("]") ? 1 : 0) != 0);
    }

    @Test
    public void testJsonIterAsMap() throws IOException {
        JsonObject jobj = (JsonObject)Json.createObjectBuilder().add("intVal", 1).add("strVal", "abc").add("boolVal", true).add("dblVal", 2.0).add("arr", (JsonArray)Json.createArrayBuilder().add(1).add("str").add(true).add(Json.createArrayBuilder()).build()).add("obj", (JsonObject)Json.createObjectBuilder().add("innerIntVal", 1).build()).build();
        String json = jobj.toString();
        Map data = Json.parse((String)json).asMap();
        Assert.assertEquals((Object)1L, data.get("intVal"));
        Assert.assertEquals((Object)"abc", data.get("strVal"));
        Assert.assertEquals((Object)true, data.get("boolVal"));
        Assert.assertEquals((Object)2.0, data.get("dblVal"));
        Assert.assertTrue((boolean)(data.get("obj") instanceof Map));
        Map obj = (Map)data.get("obj");
        Assert.assertEquals((Object)1L, obj.get("innerIntVal"));
    }

    @Test
    public void testHandleIipDataClasses() {
        iip.datatypes.Data d;
        String str;
        DataImpl data = new DataImpl();
        data.setValue(20);
        try {
            String str2 = Json.toJsonDflt((Object)data);
            Assert.assertFalse((boolean)str2.contains("iField"));
            Assert.assertTrue((boolean)str2.contains("value"));
            Json.fromJsonDflt((Object)str2, iip.datatypes.Data.class);
            Assert.fail((String)"Shall not succeed as cannot instantiate interface");
        }
        catch (IOException str2) {
            // empty catch block
        }
        Json json = Json.createInstance((Class[])new Class[]{iip.datatypes.Data.class, DataImpl.class}).handleIipDataClasses();
        try {
            str = json.toJson((Object)data);
            Assert.assertTrue((boolean)str.contains("iField"));
            Assert.assertFalse((boolean)str.contains("value"));
            d = (iip.datatypes.Data)json.fromJson((Object)str, iip.datatypes.Data.class);
            Assert.assertNotNull((Object)d);
            Assert.assertEquals((long)data.getValue(), (long)d.getValue());
        }
        catch (IOException e) {
            Assert.fail((String)"Shall not fail");
        }
        json = Json.createInstance4All().handleIipDataClasses();
        try {
            str = json.toJson((Object)data);
            Assert.assertTrue((boolean)str.contains("iField"));
            Assert.assertFalse((boolean)str.contains("value"));
            d = (iip.datatypes.Data)json.fromJson((Object)str, iip.datatypes.Data.class);
            Assert.assertNotNull((Object)d);
            Assert.assertEquals((long)data.getValue(), (long)d.getValue());
        }
        catch (IOException e) {
            Assert.fail((String)"Shall not fail");
        }
    }

    @Test
    public void testExceptFields() throws IOException {
        DataImpl data = new DataImpl();
        Json json = Json.createInstance().exceptFields(new String[]{"value"});
        String str = json.toJson((Object)data);
        Assert.assertFalse((boolean)str.contains("iField"));
        Assert.assertFalse((boolean)str.contains("value"));
        json = Json.createInstance4All().exceptFields(new String[]{"iField"});
        str = json.toJson((Object)data);
        Assert.assertFalse((boolean)str.contains("iField"));
        Assert.assertFalse((boolean)str.contains("value"));
    }

    @Test
    public void testGenerator() throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = Json.createGenerator((Writer)writer);
        gen.writeStartObject();
        gen.writeFieldName("test");
        gen.writeNumber(1);
        gen.writeFieldName("val");
        gen.writeNull();
        gen.writeFieldName("text");
        gen.writeString("abc");
        gen.writeFieldName("flag");
        gen.writeBoolean(true);
        gen.writeFieldName("arr");
        gen.writeArray(new int[]{1, 2}, 0, 2);
        gen.writeFieldName("arr2");
        gen.writeStartArray();
        gen.writeNumber(1.23);
        gen.writeEndArray();
        gen.writeEndObject();
        gen.close();
        String tmp = writer.toString();
        JsonObject obj = Json.createObject((String)tmp);
        Assert.assertTrue((boolean)obj.containsKey("test"));
        Assert.assertEquals((long)1L, (long)obj.getInt("test"));
        Assert.assertTrue((boolean)obj.containsKey("val"));
        Assert.assertNull((Object)obj.getValue("val"));
        Assert.assertTrue((boolean)obj.containsKey("text"));
        Assert.assertEquals((Object)"abc", (Object)obj.getString("text"));
        Assert.assertTrue((boolean)obj.containsKey("flag"));
        Assert.assertEquals((Object)true, (Object)obj.getBoolean("flag"));
        Assert.assertTrue((boolean)obj.containsKey("arr"));
        JsonArray arr = obj.getJsonArray("arr");
        Assert.assertNotNull((Object)arr);
        Assert.assertEquals((long)2L, (long)arr.size());
        Assert.assertEquals((long)1L, (long)arr.getInt(0));
        Assert.assertEquals((long)2L, (long)arr.getInt(1));
        Assert.assertTrue((boolean)obj.containsKey("arr2"));
        arr = obj.getJsonArray("arr2");
        Assert.assertNotNull((Object)arr);
        Assert.assertEquals((long)1L, (long)arr.size());
        Assert.assertEquals((double)1.23, (double)arr.getJsonNumber(0).doubleValue(), (double)0.01);
    }

    @Test
    public void testSerializerMigration() throws IOException {
        RoutingCommandOldImpl rcoi;
        RoutingCommandNewImpl rcni;
        RoutingCommandNewImpl rcn = rcni = new RoutingCommandNewImpl();
        rcn.setCmd("myCmdNew");
        RoutingCommandOldImpl rco = rcoi = new RoutingCommandOldImpl();
        rco.setCmd("myCmdOld");
        RoutingCommandNewSerializer rcnS = new RoutingCommandNewSerializer();
        byte[] rcnJ = rcnS.to(rcn);
        RoutingCommandNewImplSerializer rcniS = new RoutingCommandNewImplSerializer();
        byte[] rcniJ = rcniS.to(rcni);
        RoutingCommandOldSerializer rcoS = new RoutingCommandOldSerializer();
        byte[] rcoJ = rcoS.to(rco);
        RoutingCommandOldImplSerializer rcoiS = new RoutingCommandOldImplSerializer();
        byte[] rcoiJ = rcoiS.to(rco);
        RoutingCommandNewImpl rcniD = rcniS.from(rcniJ);
        RoutingCommandNew rcnD = rcnS.from(rcnJ);
        RoutingCommandOldImpl rcoiD = rcoiS.from(rcoiJ);
        RoutingCommandOld rcoD = rcoS.from(rcoJ);
        Assert.assertEquals((Object)rcoi.getCmd(), (Object)rcoiD.getCmd());
        Assert.assertEquals((Object)rcoi, (Object)rcoiD);
        Assert.assertEquals((Object)rco.getCmd(), (Object)rcoD.getCmd());
        Assert.assertEquals((Object)rco, (Object)rcoD);
        Assert.assertEquals((Object)rcni.getCmd(), (Object)rcniD.getCmd());
        Assert.assertEquals((Object)rcni, (Object)rcniD);
        Assert.assertEquals((Object)rcn.getCmd(), (Object)rcnD.getCmd());
        Assert.assertEquals((Object)rcn, (Object)rcnD);
    }

    @Test
    public void testIgnoreUnkown() throws IOException {
        Json json = Json.createInstance(TestIgnoreUnknown.class);
        String data = ((JsonObject)Json.createObjectBuilder().add("field", 123).add("flag", true).build()).toString();
        TestIgnoreUnknown obj = (TestIgnoreUnknown)json.fromJson((Object)data, TestIgnoreUnknown.class);
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)obj.getFlag());
        json = Json.createInstance().failOnUnknownProperties(false);
        obj = (TestIgnoreUnknown)json.fromJson((Object)data, TestIgnoreUnknown.class);
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)obj.getFlag());
    }

    @Test
    public void testExcludeFilter() throws IOException {
        Json json = Json.createInstance(Data.class).configureExceptFieldsFilter(FILTER_ID_DATA, new String[]{"sValue"});
        Data data = new Data();
        data.setiValue(10);
        data.setsValue("abc");
        String text = json.toJson((Object)data);
        JsonObject obj = Json.createObject((String)text);
        Assert.assertNotNull((Object)obj);
        Assert.assertFalse((boolean)obj.containsKey("sValue"));
        byte[] ser = json.writeValueAsBytes((Object)data);
        obj = Json.createObject((byte[])ser);
        Assert.assertNotNull((Object)obj);
        Assert.assertFalse((boolean)obj.containsKey("sValue"));
    }

    @Test
    public void testEnums() throws IOException {
        Json mapper = Json.createInstance4All();
        mapper.declareEnums(new Json.EnumMapping[]{mapper.createEnumValueMapping(MyEnum.class)});
        EnumTest obj = new EnumTest();
        obj.seteVal(MyEnum.VAL_1);
        String txt = mapper.toJson((Object)obj);
        EnumTest obj2 = (EnumTest)mapper.fromJson((Object)txt, EnumTest.class);
        Assert.assertNotNull((Object)obj2);
        Assert.assertEquals((Object)((Object)obj.geteVal()), (Object)((Object)obj2.geteVal()));
        Assert.assertTrue((obj.geteVal() == obj2.geteVal() ? 1 : 0) != 0);
    }

    @Filter(value="dataFilter")
    public static class Data {
        private int iValue;
        private String sValue;

        public int getiValue() {
            return this.iValue;
        }

        public void setiValue(int iValue) {
            this.iValue = iValue;
        }

        public String getsValue() {
            return this.sValue;
        }

        public void setsValue(String sValue) {
            this.sValue = sValue;
        }
    }

    @IgnoreProperties(ignoreUnknown=true)
    static class TestIgnoreUnknown {
        private boolean flag;

        TestIgnoreUnknown() {
        }

        public boolean getFlag() {
            return this.flag;
        }

        public void setFlag(boolean flag) {
            this.flag = flag;
        }
    }

    public static enum MyEnum {
        VAL_1,
        VAL_2;

    }

    public static class EnumTest {
        private MyEnum eVal;

        public MyEnum geteVal() {
            return this.eVal;
        }

        public void seteVal(MyEnum eVal) {
            this.eVal = eVal;
        }
    }
}

