/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.IterImpl;
import com.jsoniter.IterImplForStreaming;
import com.jsoniter.JsonIterator;
import java.io.IOException;

class IterImplNumber {
    static final int[] intDigits;
    static final int[] floatDigits;
    static final int END_OF_NUMBER = -2;
    static final int DOT_IN_NUMBER = -3;
    static final int INVALID_CHAR_FOR_NUMBER = -1;
    static final long[] POW10;

    IterImplNumber() {
    }

    public static final double readDouble(JsonIterator iter) throws IOException {
        byte c = IterImpl.nextToken(iter);
        if (c == 45) {
            return -IterImpl.readDouble(iter);
        }
        iter.unreadByte();
        return IterImpl.readDouble(iter);
    }

    public static final float readFloat(JsonIterator iter) throws IOException {
        return (float)IterImplNumber.readDouble(iter);
    }

    public static final int readInt(JsonIterator iter) throws IOException {
        byte c = IterImpl.nextToken(iter);
        if (c == 45) {
            return IterImpl.readInt(iter, IterImpl.readByte(iter));
        }
        int val = IterImpl.readInt(iter, c);
        if (val == Integer.MIN_VALUE) {
            throw iter.reportError("readInt", "value is too large for int");
        }
        return -val;
    }

    public static final long readLong(JsonIterator iter) throws IOException {
        byte c = IterImpl.nextToken(iter);
        if (c == 45) {
            c = IterImpl.readByte(iter);
            if (intDigits[c] == 0) {
                IterImplForStreaming.assertNotLeadingZero(iter);
                return 0L;
            }
            return IterImpl.readLong(iter, c);
        }
        if (intDigits[c] == 0) {
            IterImplForStreaming.assertNotLeadingZero(iter);
            return 0L;
        }
        long val = IterImpl.readLong(iter, c);
        if (val == Long.MIN_VALUE) {
            throw iter.reportError("readLong", "value is too large for long");
        }
        return -val;
    }

    static {
        int i;
        intDigits = new int[127];
        floatDigits = new int[127];
        POW10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L};
        for (i = 0; i < floatDigits.length; ++i) {
            IterImplNumber.floatDigits[i] = -1;
            IterImplNumber.intDigits[i] = -1;
        }
        for (i = 48; i <= 57; ++i) {
            IterImplNumber.floatDigits[i] = i - 48;
            IterImplNumber.intDigits[i] = i - 48;
        }
        IterImplNumber.floatDigits[44] = -2;
        IterImplNumber.floatDigits[93] = -2;
        IterImplNumber.floatDigits[125] = -2;
        IterImplNumber.floatDigits[32] = -2;
        IterImplNumber.floatDigits[46] = -3;
    }
}

