/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.Codegen;
import com.jsoniter.DynamicCodegen;
import com.jsoniter.IterImpl;
import com.jsoniter.IterImplArray;
import com.jsoniter.IterImplForStreaming;
import com.jsoniter.IterImplNumber;
import com.jsoniter.IterImplObject;
import com.jsoniter.IterImplSkip;
import com.jsoniter.IterImplString;
import com.jsoniter.JsonIteratorPool;
import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.spi.Config;
import com.jsoniter.spi.DecodingMode;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import com.jsoniter.spi.Slice;
import com.jsoniter.spi.TypeLiteral;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonIterator
implements Closeable {
    public Config configCache;
    private static boolean isStreamingEnabled = false;
    static final ValueType[] valueTypes = new ValueType[256];
    InputStream in;
    byte[] buf;
    int head;
    int tail;
    int skipStartedAt = -1;
    Map<String, Object> tempObjects = null;
    final Slice reusableSlice = new Slice(null, 0, 0);
    char[] reusableChars = new char[32];
    Object existingObject = null;
    private static final ReadArrayCallback fillArray;
    private static final ReadObjectCallback fillObject;

    private JsonIterator(InputStream in, byte[] buf, int head, int tail) {
        this.in = in;
        this.buf = buf;
        this.head = head;
        this.tail = tail;
    }

    public JsonIterator() {
        this(null, new byte[0], 0, 0);
    }

    public static JsonIterator parse(InputStream in, int bufSize) {
        JsonIterator.enableStreamingSupport();
        return new JsonIterator(in, new byte[bufSize], 0, 0);
    }

    public static JsonIterator parse(byte[] buf) {
        return new JsonIterator(null, buf, 0, buf.length);
    }

    public static JsonIterator parse(byte[] buf, int head, int tail) {
        return new JsonIterator(null, buf, head, tail);
    }

    public static JsonIterator parse(String str) {
        return JsonIterator.parse(str.getBytes());
    }

    public static JsonIterator parse(Slice slice) {
        return new JsonIterator(null, slice.data(), slice.head(), slice.tail());
    }

    public final void reset(byte[] buf) {
        this.buf = buf;
        this.head = 0;
        this.tail = buf.length;
    }

    public final void reset(byte[] buf, int head, int tail) {
        this.buf = buf;
        this.head = head;
        this.tail = tail;
    }

    public final void reset(Slice value) {
        this.buf = value.data();
        this.head = value.head();
        this.tail = value.tail();
    }

    public final void reset(InputStream in) {
        JsonIterator.enableStreamingSupport();
        this.in = in;
        this.head = 0;
        this.tail = 0;
    }

    @Override
    public final void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    final void unreadByte() {
        if (this.head == 0) {
            throw this.reportError("unreadByte", "unread too many bytes");
        }
        --this.head;
    }

    public final JsonException reportError(String op, String msg) {
        int peekStart = this.head - 10;
        if (peekStart < 0) {
            peekStart = 0;
        }
        int peekSize = this.head - peekStart;
        if (this.head > this.tail) {
            peekSize = this.tail - peekStart;
        }
        String peek = new String(this.buf, peekStart, peekSize);
        throw new JsonException(op + ": " + msg + ", head: " + this.head + ", peek: " + peek + ", buf: " + new String(this.buf));
    }

    public final String currentBuffer() {
        int peekStart = this.head - 10;
        if (peekStart < 0) {
            peekStart = 0;
        }
        String peek = new String(this.buf, peekStart, this.head - peekStart);
        return "head: " + this.head + ", peek: " + peek + ", buf: " + new String(this.buf);
    }

    public final boolean readNull() throws IOException {
        byte c = IterImpl.nextToken(this);
        if (c != 110) {
            this.unreadByte();
            return false;
        }
        IterImpl.skipFixedBytes(this, 3);
        return true;
    }

    public final boolean readBoolean() throws IOException {
        byte c = IterImpl.nextToken(this);
        if (116 == c) {
            IterImpl.skipFixedBytes(this, 3);
            return true;
        }
        if (102 == c) {
            IterImpl.skipFixedBytes(this, 4);
            return false;
        }
        throw this.reportError("readBoolean", "expect t or f, found: " + c);
    }

    public final short readShort() throws IOException {
        int v = this.readInt();
        if (Short.MIN_VALUE <= v && v <= Short.MAX_VALUE) {
            return (short)v;
        }
        throw this.reportError("readShort", "short overflow: " + v);
    }

    public final int readInt() throws IOException {
        return IterImplNumber.readInt(this);
    }

    public final long readLong() throws IOException {
        return IterImplNumber.readLong(this);
    }

    public final boolean readArray() throws IOException {
        return IterImplArray.readArray(this);
    }

    public String readNumberAsString() throws IOException {
        IterImplForStreaming.numberChars numberChars2 = IterImplForStreaming.readNumber(this);
        return new String(numberChars2.chars, 0, numberChars2.charsLength);
    }

    public final boolean readArrayCB(ReadArrayCallback callback, Object attachment) throws IOException {
        return IterImplArray.readArrayCB(this, callback, attachment);
    }

    public final String readString() throws IOException {
        return IterImplString.readString(this);
    }

    public final Slice readStringAsSlice() throws IOException {
        return IterImpl.readSlice(this);
    }

    public final String readObject() throws IOException {
        return IterImplObject.readObject(this);
    }

    public final void readObjectCB(ReadObjectCallback cb, Object attachment) throws IOException {
        IterImplObject.readObjectCB(this, cb, attachment);
    }

    public final float readFloat() throws IOException {
        return IterImplNumber.readFloat(this);
    }

    public final double readDouble() throws IOException {
        return IterImplNumber.readDouble(this);
    }

    public final BigDecimal readBigDecimal() throws IOException {
        ValueType valueType = this.whatIsNext();
        if (valueType == ValueType.NULL) {
            this.skip();
            return null;
        }
        if (valueType != ValueType.NUMBER) {
            throw this.reportError("readBigDecimal", "not number");
        }
        IterImplForStreaming.numberChars numberChars2 = IterImplForStreaming.readNumber(this);
        return new BigDecimal(numberChars2.chars, 0, numberChars2.charsLength);
    }

    public final BigInteger readBigInteger() throws IOException {
        ValueType valueType = this.whatIsNext();
        if (valueType == ValueType.NULL) {
            this.skip();
            return null;
        }
        if (valueType != ValueType.NUMBER) {
            throw this.reportError("readBigDecimal", "not number");
        }
        IterImplForStreaming.numberChars numberChars2 = IterImplForStreaming.readNumber(this);
        return new BigInteger(new String(numberChars2.chars, 0, numberChars2.charsLength));
    }

    public final Any readAny() throws IOException {
        try {
            return IterImpl.readAny(this);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.reportError("read", "premature end");
        }
    }

    public final Object read() throws IOException {
        try {
            ValueType valueType = this.whatIsNext();
            switch (valueType) {
                case STRING: {
                    return this.readString();
                }
                case NUMBER: {
                    IterImplForStreaming.numberChars numberChars2 = IterImplForStreaming.readNumber(this);
                    Double number = Double.valueOf(new String(numberChars2.chars, 0, numberChars2.charsLength));
                    if (numberChars2.dotFound) {
                        return number;
                    }
                    double doubleNumber = number;
                    if (doubleNumber == Math.floor(doubleNumber) && !Double.isInfinite(doubleNumber)) {
                        long longNumber = (long)doubleNumber;
                        if (longNumber <= Integer.MAX_VALUE && longNumber >= Integer.MIN_VALUE) {
                            return (int)longNumber;
                        }
                        return longNumber;
                    }
                    return number;
                }
                case NULL: {
                    IterImpl.skipFixedBytes(this, 4);
                    return null;
                }
                case BOOLEAN: {
                    return this.readBoolean();
                }
                case ARRAY: {
                    ArrayList list = new ArrayList(4);
                    this.readArrayCB(fillArray, list);
                    return list;
                }
                case OBJECT: {
                    HashMap map = new HashMap(4);
                    this.readObjectCB(fillObject, map);
                    return map;
                }
            }
            throw this.reportError("read", "unexpected value type: " + (Object)((Object)valueType));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.reportError("read", "premature end");
        }
    }

    public final <T> T read(T existingObject) throws IOException {
        try {
            this.existingObject = existingObject;
            Class<?> clazz = existingObject.getClass();
            String cacheKey = this.currentConfig().getDecoderCacheKey(clazz);
            return (T)Codegen.getDecoder(cacheKey, clazz).decode(this);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.reportError("read", "premature end");
        }
    }

    private Config currentConfig() {
        if (this.configCache == null) {
            this.configCache = JsoniterSpi.getCurrentConfig();
        }
        return this.configCache;
    }

    public final <T> T read(TypeLiteral<T> typeLiteral, T existingObject) throws IOException {
        try {
            this.existingObject = existingObject;
            String cacheKey = this.currentConfig().getDecoderCacheKey(typeLiteral.getType());
            return (T)Codegen.getDecoder(cacheKey, typeLiteral.getType()).decode(this);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.reportError("read", "premature end");
        }
    }

    public final <T> T read(Class<T> clazz) throws IOException {
        return (T)this.read((Type)clazz);
    }

    public final <T> T read(TypeLiteral<T> typeLiteral) throws IOException {
        return (T)this.read(typeLiteral.getType());
    }

    public final Object read(Type type) throws IOException {
        try {
            String cacheKey = this.currentConfig().getDecoderCacheKey(type);
            return Codegen.getDecoder(cacheKey, type).decode(this);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.reportError("read", "premature end");
        }
    }

    public ValueType whatIsNext() throws IOException {
        ValueType valueType = valueTypes[IterImpl.nextToken(this)];
        this.unreadByte();
        return valueType;
    }

    public void skip() throws IOException {
        IterImplSkip.skip(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T deserialize(Config config, String input, Class<T> clazz) {
        JsoniterSpi.setCurrentConfig(config);
        try {
            T t = JsonIterator.deserialize(input.getBytes(), clazz);
            return t;
        }
        finally {
            JsoniterSpi.clearCurrentConfig();
        }
    }

    public static final <T> T deserialize(String input, Class<T> clazz) {
        return JsonIterator.deserialize(input.getBytes(), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T deserialize(Config config, String input, TypeLiteral<T> typeLiteral) {
        JsoniterSpi.setCurrentConfig(config);
        try {
            T t = JsonIterator.deserialize(input.getBytes(), typeLiteral);
            return t;
        }
        finally {
            JsoniterSpi.clearCurrentConfig();
        }
    }

    public static final <T> T deserialize(String input, TypeLiteral<T> typeLiteral) {
        return JsonIterator.deserialize(input.getBytes(), typeLiteral);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T deserialize(Config config, byte[] input, Class<T> clazz) {
        JsoniterSpi.setCurrentConfig(config);
        try {
            T t = JsonIterator.deserialize(input, clazz);
            return t;
        }
        finally {
            JsoniterSpi.clearCurrentConfig();
        }
    }

    public static final <T> T deserialize(byte[] input, Class<T> clazz) {
        int lastNotSpacePos = JsonIterator.findLastNotSpacePos(input);
        JsonIterator iter = JsonIteratorPool.borrowJsonIterator();
        iter.reset(input, 0, lastNotSpacePos);
        try {
            T val = iter.read(clazz);
            if (iter.head != lastNotSpacePos) {
                throw iter.reportError("deserialize", "trailing garbage found");
            }
            T t = val;
            return t;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw iter.reportError("deserialize", "premature end");
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonIteratorPool.returnJsonIterator(iter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T deserialize(Config config, byte[] input, TypeLiteral<T> typeLiteral) {
        JsoniterSpi.setCurrentConfig(config);
        try {
            T t = JsonIterator.deserialize(input, typeLiteral);
            return t;
        }
        finally {
            JsoniterSpi.clearCurrentConfig();
        }
    }

    public static final <T> T deserialize(byte[] input, TypeLiteral<T> typeLiteral) {
        int lastNotSpacePos = JsonIterator.findLastNotSpacePos(input);
        JsonIterator iter = JsonIteratorPool.borrowJsonIterator();
        iter.reset(input, 0, lastNotSpacePos);
        try {
            T val = iter.read(typeLiteral);
            if (iter.head != lastNotSpacePos) {
                throw iter.reportError("deserialize", "trailing garbage found");
            }
            T t = val;
            return t;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw iter.reportError("deserialize", "premature end");
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonIteratorPool.returnJsonIterator(iter);
        }
    }

    public static final Any deserialize(Config config, String input) {
        JsoniterSpi.setCurrentConfig(config);
        try {
            Any any = JsonIterator.deserialize(input.getBytes());
            return any;
        }
        finally {
            JsoniterSpi.clearCurrentConfig();
        }
    }

    public static final Any deserialize(String input) {
        return JsonIterator.deserialize(input.getBytes());
    }

    public static final Any deserialize(Config config, byte[] input) {
        JsoniterSpi.setCurrentConfig(config);
        try {
            Any any = JsonIterator.deserialize(input);
            return any;
        }
        finally {
            JsoniterSpi.clearCurrentConfig();
        }
    }

    public static final Any deserialize(byte[] input) {
        int lastNotSpacePos = JsonIterator.findLastNotSpacePos(input);
        JsonIterator iter = JsonIteratorPool.borrowJsonIterator();
        iter.reset(input, 0, lastNotSpacePos);
        try {
            Any val = iter.readAny();
            if (iter.head != lastNotSpacePos) {
                throw iter.reportError("deserialize", "trailing garbage found");
            }
            Any any = val;
            return any;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw iter.reportError("deserialize", "premature end");
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonIteratorPool.returnJsonIterator(iter);
        }
    }

    private static int findLastNotSpacePos(byte[] input) {
        for (int i = input.length - 1; i >= 0; --i) {
            byte c = input[i];
            if (c == 32 || c == 9 || c == 10 || c == 13) continue;
            return i + 1;
        }
        return 0;
    }

    public static void setMode(DecodingMode mode) {
        Config newConfig = JsoniterSpi.getDefaultConfig().copyBuilder().decodingMode(mode).build();
        JsoniterSpi.setDefaultConfig(newConfig);
        JsoniterSpi.setCurrentConfig(newConfig);
    }

    public static void enableStreamingSupport() {
        if (isStreamingEnabled) {
            return;
        }
        isStreamingEnabled = true;
        try {
            DynamicCodegen.enableStreamingSupport();
        }
        catch (JsonException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    static {
        for (int i = 0; i < valueTypes.length; ++i) {
            JsonIterator.valueTypes[i] = ValueType.INVALID;
        }
        JsonIterator.valueTypes[34] = ValueType.STRING;
        JsonIterator.valueTypes[45] = ValueType.NUMBER;
        JsonIterator.valueTypes[48] = ValueType.NUMBER;
        JsonIterator.valueTypes[49] = ValueType.NUMBER;
        JsonIterator.valueTypes[50] = ValueType.NUMBER;
        JsonIterator.valueTypes[51] = ValueType.NUMBER;
        JsonIterator.valueTypes[52] = ValueType.NUMBER;
        JsonIterator.valueTypes[53] = ValueType.NUMBER;
        JsonIterator.valueTypes[54] = ValueType.NUMBER;
        JsonIterator.valueTypes[55] = ValueType.NUMBER;
        JsonIterator.valueTypes[56] = ValueType.NUMBER;
        JsonIterator.valueTypes[57] = ValueType.NUMBER;
        JsonIterator.valueTypes[116] = ValueType.BOOLEAN;
        JsonIterator.valueTypes[102] = ValueType.BOOLEAN;
        JsonIterator.valueTypes[110] = ValueType.NULL;
        JsonIterator.valueTypes[91] = ValueType.ARRAY;
        JsonIterator.valueTypes[123] = ValueType.OBJECT;
        fillArray = new ReadArrayCallback(){

            @Override
            public boolean handle(JsonIterator iter, Object attachment) throws IOException {
                List list = (List)attachment;
                list.add(iter.read());
                return true;
            }
        };
        fillObject = new ReadObjectCallback(){

            @Override
            public boolean handle(JsonIterator iter, String field, Object attachment) throws IOException {
                Map map = (Map)attachment;
                map.put(field, iter.read());
                return true;
            }
        };
    }

    public static interface ReadObjectCallback {
        public boolean handle(JsonIterator var1, String var2, Object var3) throws IOException;
    }

    public static interface ReadArrayCallback {
        public boolean handle(JsonIterator var1, Object var2) throws IOException;
    }
}

