/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.extra;

import com.jsoniter.JsonIterator;
import com.jsoniter.extra.Base64;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.Decoder;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import com.jsoniter.spi.Slice;
import java.io.IOException;

public class Base64Support {
    private static boolean enabled;

    public static synchronized void enable() {
        if (enabled) {
            throw new JsonException("Base64Support.enable can only be called once");
        }
        enabled = true;
        JsoniterSpi.registerTypeDecoder(byte[].class, new Decoder(){

            @Override
            public Object decode(JsonIterator iter) throws IOException {
                Slice slice = iter.readStringAsSlice();
                return Base64.decodeFast(slice.data(), slice.head(), slice.tail());
            }
        });
        JsoniterSpi.registerTypeEncoder(byte[].class, new Encoder(){

            @Override
            public void encode(Object obj, JsonStream stream) throws IOException {
                byte[] bytes = (byte[])obj;
                stream.write(34);
                Base64.encodeToBytes(bytes, stream);
                stream.write(34);
            }
        });
    }
}

