/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.jsoniter.JsonIterator;
import com.jsoniter.any.Any;
import de.iip_ecosphere.platform.support.json.IOIterator;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonArrayBuilder;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.json.JsonObjectBuilder;
import de.oktoflow.platform.support.json.jackson.JerseyJsonObject;
import de.oktoflow.platform.support.json.jackson.JsonUtils;
import de.oktoflow.platform.support.json.jackson.JsoniterAny;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JacksonJson
extends Json {
    private ObjectMapper mapper = new ObjectMapper();
    private ObjectWriter writer;
    private JsonUtils.OktoAnnotationIntrospector introspector;

    public Json createInstanceImpl(boolean considerAnnotations) {
        return considerAnnotations ? new JacksonJson4All() : new JacksonJson();
    }

    public String toJson(Object obj) throws IOException {
        String result = "";
        if (null != obj) {
            try {
                result = null != this.writer ? this.writer.writeValueAsString(obj) : this.mapper.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                throw new IOException(e);
            }
        }
        return result;
    }

    public <R> R fromJson(Object json, Class<R> cls) throws IOException {
        Object result = null;
        if (null != json) {
            try {
                result = this.mapper.readValue(json.toString(), cls);
            }
            catch (JsonProcessingException e) {
                throw new IOException(e);
            }
        }
        return (R)result;
    }

    public <R> List<R> listFromJson(Object json, Class<R> cls) {
        List result = null;
        if (null != json) {
            try {
                result = (List)this.mapper.readValue(json.toString(), new ListTypeReference());
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }

    public <K, V> Map<K, V> mapFromJson(Object json, Class<K> keyCls, Class<V> valueCls) {
        Map result = null;
        if (null != json) {
            try {
                result = (Map)this.mapper.readValue(json.toString(), new MapTypeReference());
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }

    public <T> T readValue(String src, Class<T> cls) throws IOException {
        try {
            return (T)this.mapper.readValue(src, cls);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public <T> T readValue(byte[] src, Class<T> valueType) throws IOException {
        try {
            return (T)this.mapper.readValue(src, valueType);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public byte[] writeValueAsBytes(Object value) throws IOException {
        try {
            if (this.writer != null) {
                return this.writer.writeValueAsBytes(value);
            }
            return this.mapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public String writeValueAsString(Object value) throws IOException {
        try {
            if (this.writer != null) {
                return this.writer.writeValueAsString(value);
            }
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public Json configureFor(Class<?> cls) {
        this.introspector = JsonUtils.configureFor(this.mapper, this.introspector, cls);
        return this;
    }

    public Json handleIipDataClasses() {
        this.mapper = JsonUtils.handleIipDataClasses(this.mapper);
        return this;
    }

    public Json defineOptionals(Class<?> cls, String ... fieldNames) {
        this.mapper = JsonUtils.defineOptionals(this.mapper, cls, fieldNames);
        return this;
    }

    public Json defineFields(String ... fieldNames) {
        this.mapper = JsonUtils.defineFields(this.mapper, fieldNames);
        return this;
    }

    public Json exceptFields(String ... fieldNames) {
        this.introspector = JsonUtils.exceptFields(this.mapper, this.introspector, fieldNames);
        return this;
    }

    public Json configureExceptFieldsFilter(String filterId, String ... fieldNames) {
        SimpleBeanPropertyFilter theFilter = SimpleBeanPropertyFilter.serializeAllExcept((String[])fieldNames);
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter(filterId, theFilter);
        this.writer = this.mapper.writer((FilterProvider)filters);
        return this;
    }

    public Json filterAllExceptFields(String ... fieldNames) {
        SimpleBeanPropertyFilter theFilter = SimpleBeanPropertyFilter.serializeAllExcept((String[])fieldNames);
        SimpleFilterProvider filters = new SimpleFilterProvider().setDefaultFilter(theFilter);
        this.writer = this.mapper.writer((FilterProvider)filters);
        return this;
    }

    public <T> T convertValue(Object value, Class<T> cls) throws IllegalArgumentException {
        return (T)this.mapper.convertValue(value, cls);
    }

    public Json failOnUnknownProperties(boolean fail) {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return this;
    }

    public <T> Json.EnumMapping<T> createEnumMapping(Class<T> type, Map<String, T> mapping) {
        return new JsonUtils.JacksonEnumMapping<T>(type, mapping);
    }

    public Json declareEnums(Json.EnumMapping<?> ... mappings) {
        JsonUtils.declareEnums(this.mapper, mappings);
        return this;
    }

    public Json configureLazy(Set<Object> ignore) {
        this.introspector = JsonUtils.configureLazy(this.mapper, this.introspector, ignore);
        return this;
    }

    public <T> IOIterator<T> createIterator(InputStream stream, Class<T> cls) throws IOException {
        return JsonUtils.createIterator(this.mapper, stream, cls);
    }

    protected JsonObject createObjectImpl(Reader reader) throws IOException {
        return JerseyJsonObject.createObject(reader);
    }

    protected JsonObjectBuilder createObjectBuilderImpl() {
        return JerseyJsonObject.createObjectBuilder();
    }

    protected JsonArrayBuilder createArrayBuilderImpl() {
        return JerseyJsonObject.createArrayBuilder();
    }

    protected de.iip_ecosphere.platform.support.json.JsonIterator parseImpl(String text) {
        return new JsoniterAny(JsonIterator.deserialize((String)text));
    }

    protected de.iip_ecosphere.platform.support.json.JsonIterator parseImpl(byte[] data) {
        Any tmp = data[0] == 91 ? Any.lazyArray((byte[])data, (int)0, (int)data.length) : Any.lazyObject((byte[])data, (int)0, (int)(data.length - 1));
        return new JsoniterAny(tmp);
    }

    protected de.iip_ecosphere.platform.support.json.JsonGenerator createGeneratorImpl(Writer writer) throws IOException {
        JsonFactory f = this.mapper.getFactory();
        return new JacksonJsonGenerator(f.createGenerator(writer));
    }

    private class JacksonJson4All
    extends JacksonJson {
        private Set<Class<?>> configured = new HashSet();

        private JacksonJson4All() {
        }

        private <T> Class<T> cfg(Class<T> cls) {
            if (!this.configured.contains(cls)) {
                this.configureFor(cls);
            }
            return cls;
        }

        private Object cfg(Object obj) {
            if (null != obj) {
                this.cfg(obj.getClass());
            }
            return obj;
        }

        @Override
        public String toJson(Object obj) throws IOException {
            return super.toJson(this.cfg(obj));
        }

        @Override
        public <R> R fromJson(Object json, Class<R> cls) throws IOException {
            return super.fromJson(json, this.cfg(cls));
        }

        @Override
        public <R> List<R> listFromJson(Object json, Class<R> cls) {
            return JacksonJson.listFromJsonDflt((Object)json, this.cfg(cls));
        }

        @Override
        public <K, V> Map<K, V> mapFromJson(Object json, Class<K> keyCls, Class<V> valueCls) {
            return super.mapFromJson(json, this.cfg(keyCls), this.cfg(valueCls));
        }

        @Override
        public <T> T readValue(String src, Class<T> cls) throws IOException {
            return super.readValue(src, this.cfg(cls));
        }

        @Override
        public <T> T readValue(byte[] src, Class<T> valueType) throws IOException {
            return super.readValue(src, this.cfg(valueType));
        }

        @Override
        public <T> T convertValue(Object value, Class<T> cls) throws IllegalArgumentException {
            this.cfg(cls);
            return super.convertValue(value, this.cfg(cls));
        }

        @Override
        public <T> Json.EnumMapping<T> createEnumMapping(Class<T> type, Map<String, T> mapping) {
            return super.createEnumMapping(this.cfg(type), mapping);
        }

        @Override
        public byte[] writeValueAsBytes(Object value) throws IOException {
            return super.writeValueAsBytes(this.cfg(value));
        }

        @Override
        public String writeValueAsString(Object value) throws IOException {
            return super.writeValueAsString(this.cfg(value));
        }
    }

    private static class ListTypeReference<T>
    extends TypeReference<List<T>> {
        private ListTypeReference() {
        }
    }

    private static class MapTypeReference<K, V>
    extends TypeReference<Map<K, V>> {
        private MapTypeReference() {
        }
    }

    private static class JacksonJsonGenerator
    implements de.iip_ecosphere.platform.support.json.JsonGenerator {
        private JsonGenerator gen;

        private JacksonJsonGenerator(JsonGenerator gen) {
            this.gen = gen;
        }

        public void close() throws IOException {
            this.gen.close();
        }

        public void writeNumber(short number) throws IOException {
            this.gen.writeNumber(number);
        }

        public void writeNumber(int number) throws IOException {
            this.gen.writeNumber(number);
        }

        public void writeNumber(long number) throws IOException {
            this.gen.writeNumber(number);
        }

        public void writeNumber(BigInteger number) throws IOException {
            this.gen.writeNumber(number);
        }

        public void writeNumber(double number) throws IOException {
            this.gen.writeNumber(number);
        }

        public void writeNumber(float number) throws IOException {
            this.gen.writeNumber(number);
        }

        public void writeNumber(BigDecimal number) throws IOException {
            this.gen.writeNumber(number);
        }

        public void writeString(String text) throws IOException {
            this.gen.writeString(text);
        }

        public void writeBoolean(boolean value) throws IOException {
            this.gen.writeBoolean(value);
        }

        public void writeNull() throws IOException {
            this.gen.writeNull();
        }

        public void writeArray(int[] array, int offset, int length) throws IOException {
            this.gen.writeArray(array, offset, length);
        }

        public void writeArray(long[] array, int offset, int length) throws IOException {
            this.gen.writeArray(array, offset, length);
        }

        public void writeArray(double[] array, int offset, int length) throws IOException {
            this.gen.writeArray(array, offset, length);
        }

        public void writeArray(String[] array, int offset, int length) throws IOException {
            this.gen.writeArray(array, offset, length);
        }

        public void writeStartArray() throws IOException {
            this.gen.writeStartArray();
        }

        public void writeEndArray() throws IOException {
            this.gen.writeEndArray();
        }

        public void writeStartObject() throws IOException {
            this.gen.writeStartObject();
        }

        public void writeEndObject() throws IOException {
            this.gen.writeEndObject();
        }

        public void writeFieldName(String name) throws IOException {
            this.gen.writeFieldName(name);
        }

        public void writeObject(Object object) throws IOException {
            this.gen.writeObject(object);
        }
    }
}

