/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.json.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.ConfiguredName;
import de.iip_ecosphere.platform.support.Filter;
import de.iip_ecosphere.platform.support.Ignore;
import de.iip_ecosphere.platform.support.IgnoreProperties;
import de.iip_ecosphere.platform.support.Include;
import de.iip_ecosphere.platform.support.json.IOIterator;
import de.iip_ecosphere.platform.support.json.Json;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class JsonUtils {
    public static final SimpleAbstractTypeResolver IIP_TYPE_RESOLVER = new SimpleAbstractTypeResolver(){
        private static final long serialVersionUID = -3746467806797935401L;

        public JavaType findTypeMapping(DeserializationConfig config, JavaType type) {
            JavaType result = null;
            String className = type.getRawClass().getName();
            if (type.isInterface() && className.startsWith("iip.")) {
                String name = className + "Impl";
                try {
                    Class<?> cls = Class.forName(name);
                    result = config.getTypeFactory().constructType(cls);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (null == result) {
                result = super.findTypeMapping(config, type);
            }
            return result;
        }
    };

    public static OktoAnnotationIntrospector configureFor(ObjectMapper mapper, OktoAnnotationIntrospector introspector, Class<?> cls) {
        IgnoreProperties annIgnoreProp = cls.getAnnotation(IgnoreProperties.class);
        JsonIgnoreProperties jsonIgnoreProp = cls.getAnnotation(JsonIgnoreProperties.class);
        HashMap<String, String> renames = new HashMap<String, String>();
        HashSet<String> nonNullInclude = new HashSet<String>();
        if (null != annIgnoreProp && annIgnoreProp.ignoreUnknown()) {
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        if (null != jsonIgnoreProp && jsonIgnoreProp.ignoreUnknown()) {
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        for (Field field : cls.getDeclaredFields()) {
            JsonUtils.handleAnnotations(field.getName(), field, renames, nonNullInclude);
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
            String name = ((Method)accessibleObject).getName();
            if (name.length() > 3 && (name.startsWith("get") || name.startsWith("set"))) {
                name = name.substring(3);
            }
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            JsonUtils.handleAnnotations(name, accessibleObject, renames, nonNullInclude);
        }
        if (nonNullInclude.size() > 0) {
            SimpleModule module = new SimpleModule();
            module.setSerializerModifier((BeanSerializerModifier)new CustomPropertyInclusionModifier(cls, nonNullInclude));
            mapper.registerModule((Module)module);
        }
        if (!renames.isEmpty()) {
            CustomPropertyNamingStrategy cpns;
            PropertyNamingStrategy pns = mapper.getPropertyNamingStrategy();
            if (pns instanceof CustomPropertyNamingStrategy) {
                cpns = (CustomPropertyNamingStrategy)pns;
            } else {
                cpns = new CustomPropertyNamingStrategy();
                mapper.setPropertyNamingStrategy((PropertyNamingStrategy)cpns);
            }
            cpns.addMapping(cls, renames);
        }
        return JsonUtils.setAnnotationIntrospector(mapper, introspector, null);
    }

    private static void handleAnnotations(String propName, AccessibleObject obj, Map<String, String> renames, Set<String> nonNullInclude) {
        ConfiguredName cfgName = obj.getAnnotation(ConfiguredName.class);
        Include annIncl = obj.getAnnotation(Include.class);
        if (null != cfgName && JsonUtils.isRename(cfgName.value(), propName)) {
            renames.put(propName, cfgName.value());
        }
        if (null != annIncl && annIncl.value() == Include.Type.NON_NULL) {
            nonNullInclude.add(propName);
        }
    }

    private static boolean isRename(String cfgName, String propName) {
        return cfgName != null && cfgName.length() > 0 && !propName.equals(cfgName);
    }

    public static ObjectMapper handleIipDataClasses(ObjectMapper mapper) {
        SimpleModule iipModule = new SimpleModule();
        iipModule.setAbstractTypes(IIP_TYPE_RESOLVER);
        return mapper.registerModule((Module)iipModule);
    }

    public static ObjectMapper defineOptionals(ObjectMapper mapper, Class<?> cls, String ... fieldNames) {
        return mapper.addHandler((DeserializationProblemHandler)new OptionalFieldsDeserializationProblemHandler(cls, fieldNames));
    }

    public static ObjectMapper defineFields(ObjectMapper mapper, String ... fieldNames) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (String fn : fieldNames) {
            String javaField = fn;
            if (javaField.length() > 0) {
                javaField = Character.toUpperCase(javaField.charAt(0)) + javaField.substring(1);
            }
            mapping.put(javaField, fn);
        }
        return mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new MappingPropertyNamingStrategy(mapping));
    }

    private static OktoAnnotationIntrospector setAnnotationIntrospector(ObjectMapper mapper, OktoAnnotationIntrospector introspector, Consumer<OktoAnnotationIntrospector> configurer) {
        if (null == introspector) {
            introspector = new OktoAnnotationIntrospector();
            mapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
        }
        if (null != configurer) {
            configurer.accept(introspector);
        }
        return introspector;
    }

    public static OktoAnnotationIntrospector exceptFields(ObjectMapper mapper, OktoAnnotationIntrospector introspector, String ... fieldNames) {
        Set exclusions = CollectionUtils.addAll(new HashSet(), (Object[])fieldNames);
        return JsonUtils.setAnnotationIntrospector(mapper, introspector, i -> ((OktoAnnotationIntrospector)i).exclusions = exclusions);
    }

    public static String toJson(ObjectMapper mapper, Object object) {
        String result = "";
        if (null != object) {
            try {
                result = mapper.writeValueAsString(object);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static ObjectMapper declareEnums(ObjectMapper mapper, Json.EnumMapping<?> ... mappings) {
        SimpleModule module = new SimpleModule();
        for (Json.EnumMapping<?> m : mappings) {
            if (!(m instanceof JacksonEnumMapping)) continue;
            ((JacksonEnumMapping)m).addToModule(module);
        }
        return mapper.registerModule((Module)module);
    }

    public static OktoAnnotationIntrospector configureLazy(ObjectMapper mapper, OktoAnnotationIntrospector introspector, Set<Object> ignore) {
        OktoAnnotationIntrospector result = introspector;
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_ARRAY);
        if (!ignore.isEmpty()) {
            result = JsonUtils.setAnnotationIntrospector(mapper, result, i -> ((OktoAnnotationIntrospector)i).ignore = ignore);
        }
        return result;
    }

    public static <T> IOIterator<T> createIterator(ObjectMapper mapper, InputStream stream, final Class<T> cls) throws IOException {
        JsonFactory jf = new JsonFactory();
        final JsonParser jp = jf.createParser(stream);
        jp.setCodec((ObjectCodec)mapper);
        jp.nextToken();
        return new IOIterator<T>(){

            public boolean hasNext() throws IOException {
                return jp.hasCurrentToken();
            }

            public T next() throws IOException {
                Object data = jp.readValueAs(cls);
                jp.nextToken();
                return data;
            }
        };
    }

    public static class CustomPropertyInclusionModifier
    extends BeanSerializerModifier {
        private final Set<String> nonNullInclude;
        private final Class<?> targetClass;

        public CustomPropertyInclusionModifier(Class<?> targetClass, Set<String> nonNullInclude) {
            this.targetClass = targetClass;
            this.nonNullInclude = nonNullInclude;
        }

        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
            if (beanDesc.getBeanClass() == this.targetClass) {
                ArrayList<BeanPropertyWriter> newProperties = new ArrayList<BeanPropertyWriter>();
                for (BeanPropertyWriter writer : beanProperties) {
                    if (this.nonNullInclude != null && this.nonNullInclude.contains(writer.getName())) {
                        newProperties.add(new JsonNullableBeanPropertyWriter(writer));
                        continue;
                    }
                    newProperties.add(writer);
                }
                return newProperties;
            }
            return super.changeProperties(config, beanDesc, beanProperties);
        }
    }

    public static class CustomPropertyNamingStrategy
    extends PropertyNamingStrategy {
        private static final long serialVersionUID = -6610876934860406571L;
        private final Map<Class<?>, Map<String, String>> propertyRenameMap = new HashMap();

        public void addMapping(Class<?> cls, Map<String, String> mapping) {
            this.propertyRenameMap.put(cls, mapping);
        }

        private String getMapping(Class<?> cls, String defaultName, Supplier<String> fallback) {
            Map<String, String> mapping = this.propertyRenameMap.get(cls);
            if (null != mapping && mapping.containsKey(defaultName)) {
                return mapping.get(defaultName);
            }
            return fallback.get();
        }

        public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
            return this.getMapping(field.getDeclaringClass(), defaultName, () -> super.nameForField(config, field, defaultName));
        }

        public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.getMapping(method.getDeclaringClass(), defaultName, () -> super.nameForGetterMethod(config, method, defaultName));
        }

        public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.getMapping(method.getDeclaringClass(), defaultName, () -> super.nameForSetterMethod(config, method, defaultName));
        }

        public String nameForConstructorParameter(MapperConfig<?> config, AnnotatedParameter ctorParam, String defaultName) {
            return this.getMapping(ctorParam.getDeclaringClass(), defaultName, () -> super.nameForConstructorParameter(config, ctorParam, defaultName));
        }
    }

    public static class OktoAnnotationIntrospector
    extends JacksonAnnotationIntrospector {
        private static final long serialVersionUID = -1021095562978855964L;
        private Set<String> exclusions;
        private Set<Object> ignore;

        public boolean hasIgnoreMarker(AnnotatedMember member) {
            Ignore ignoreAnn = (Ignore)member.getAnnotation(Ignore.class);
            if (null != ignoreAnn) {
                return ignoreAnn.value();
            }
            if (this.exclusions != null) {
                ConfiguredName cfgName;
                boolean exclude = this.exclusions.contains(member.getName());
                if (!exclude && null != (cfgName = (ConfiguredName)member.getAnnotation(ConfiguredName.class)) && cfgName.value() != null) {
                    exclude = this.exclusions.contains(cfgName.value());
                }
                return exclude;
            }
            if (null != this.ignore) {
                return this.ignore.contains(member.getType().getRawClass()) || this.ignore.contains(member.getMember());
            }
            return super.hasIgnoreMarker(member);
        }

        public PropertyName findNameForDeserialization(Annotated member) {
            ConfiguredName cfgName = (ConfiguredName)member.getAnnotation(ConfiguredName.class);
            if (cfgName != null) {
                return PropertyName.construct((String)cfgName.value());
            }
            return super.findNameForDeserialization(member);
        }

        public PropertyName findNameForSerialization(Annotated member) {
            ConfiguredName cfgName = (ConfiguredName)member.getAnnotation(ConfiguredName.class);
            if (cfgName != null) {
                return PropertyName.construct((String)cfgName.value());
            }
            return super.findNameForSerialization(member);
        }

        public JsonIgnoreProperties.Value findPropertyIgnorals(Annotated member) {
            IgnoreProperties ignoreProp = (IgnoreProperties)member.getAnnotation(IgnoreProperties.class);
            if (ignoreProp == null) {
                return JsonIgnoreProperties.Value.empty();
            }
            return super.findPropertyIgnorals(member);
        }

        public Object findFilterId(Annotated member) {
            String id;
            Filter filter = (Filter)member.getAnnotation(Filter.class);
            if (filter != null && (id = filter.value()).length() > 0) {
                return id;
            }
            return super.findFilterId(member);
        }
    }

    public static class OptionalFieldsDeserializationProblemHandler
    extends DeserializationProblemHandler {
        private Class<?> cls;
        private Set<String> optionalFields = new HashSet<String>();

        public OptionalFieldsDeserializationProblemHandler(Class<?> cls, String ... fieldNames) {
            this.cls = cls;
            for (String f : fieldNames) {
                this.optionalFields.add(f);
            }
        }

        public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser parser, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
            boolean result = this.optionalFields.contains(propertyName) && beanOrClass.getClass().equals(this.cls);
            return result;
        }
    }

    public static class MappingPropertyNamingStrategy
    extends PropertyNamingStrategy {
        private static final long serialVersionUID = -3963175454099182994L;
        private PropertyNamingStrategy fallback;
        private Map<String, String> mapping;

        public MappingPropertyNamingStrategy(Map<String, String> mapping) {
            this(mapping, new PropertyNamingStrategy());
        }

        public MappingPropertyNamingStrategy(Map<String, String> mapping, PropertyNamingStrategy fallback) {
            this.fallback = fallback;
            this.mapping = mapping;
        }

        public String nameForConstructorParameter(MapperConfig<?> config, AnnotatedParameter ctorParam, String defaultName) {
            return this.fallback.nameForConstructorParameter(config, ctorParam, defaultName);
        }

        public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
            String result = field.getName();
            if (result == null) {
                result = this.fallback.nameForField(config, field, defaultName);
            }
            return result;
        }

        public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            String result;
            String fieldName = method.getName();
            if (fieldName.startsWith("get")) {
                fieldName = fieldName.substring(3);
            }
            if ((result = this.mapping.get(fieldName)) == null) {
                result = this.fallback.nameForSetterMethod(config, method, defaultName);
            }
            return result;
        }

        public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            String result;
            String fieldName = method.getName();
            if (fieldName.startsWith("set")) {
                fieldName = fieldName.substring(3);
            }
            if ((result = this.mapping.get(fieldName)) == null) {
                result = this.fallback.nameForSetterMethod(config, method, defaultName);
            }
            return result;
        }
    }

    public static class JacksonEnumMapping<T>
    implements Json.EnumMapping<T> {
        private Class<T> type;
        private Map<String, T> mapping = new HashMap<String, T>();

        public JacksonEnumMapping(Class<T> type) {
            this(type, null);
        }

        public JacksonEnumMapping(Class<T> type, Map<String, T> mapping) {
            this.type = type;
            if (null != mapping) {
                this.mapping.putAll(mapping);
            }
        }

        public void addMapping(String name, T value) {
            this.mapping.put(name, value);
        }

        public Class<T> getType() {
            return this.type;
        }

        public void addToModule(SimpleModule module) {
            module.addDeserializer(this.type, new EnumDeserializer<T>(this.mapping, this.type));
        }
    }

    public static class JsonNullableBeanPropertyWriter
    extends BeanPropertyWriter {
        private static final long serialVersionUID = 1L;

        protected JsonNullableBeanPropertyWriter(BeanPropertyWriter base) {
            super(base);
        }

        protected JsonNullableBeanPropertyWriter(BeanPropertyWriter base, PropertyName newName) {
            super(base, newName);
        }

        protected BeanPropertyWriter _new(PropertyName newName) {
            return new JsonNullableBeanPropertyWriter(this, newName);
        }

        public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
            Object value = this.get(bean);
            if (value == null) {
                return;
            }
            super.serializeAsField(bean, jgen, prov);
        }
    }

    public static class CustomPropertyExclusionModifier
    extends BeanSerializerModifier {
        private final Set<String> propertiesToExclude;
        private final Class<?> targetClass;

        public CustomPropertyExclusionModifier(Class<?> targetClass, Set<String> propertiesToExclude) {
            this.targetClass = targetClass;
            this.propertiesToExclude = propertiesToExclude;
        }

        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
            if (beanDesc.getBeanClass() == this.targetClass) {
                ArrayList<BeanPropertyWriter> newProperties = new ArrayList<BeanPropertyWriter>();
                for (BeanPropertyWriter writer : beanProperties) {
                    if (this.propertiesToExclude == null || this.propertiesToExclude.contains(writer.getName())) continue;
                    newProperties.add(writer);
                }
                return newProperties;
            }
            return super.changeProperties(config, beanDesc, beanProperties);
        }
    }

    public static class EnumDeserializer<T>
    extends StdDeserializer<T> {
        private static final long serialVersionUID = -1654499344527076310L;
        private Map<String, T> mapping;

        public EnumDeserializer(Map<String, T> mapping, Class<T> cls) {
            super(cls);
            this.mapping = mapping;
        }

        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            T result = null;
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            String name = node.asText();
            if (null != name) {
                result = this.mapping.get(name);
            }
            return result;
        }
    }
}

