package iip.serializers;

import java.io.IOException;

import de.iip_ecosphere.platform.support.json.Json;

import iip.datatypes.*;

/**
 * JSON transport serializer for RoutingCommand.
 * Generated by: EASy-Producer.
 */
public class RoutingCommandNewImplSerializer {

    private static final Json MAPPER = Json.createInstance4All();

    static {
        MAPPER.handleIipDataClasses();
    }

    /**
     * Serializes an object.
     * 
     * @param data the source 
     * @return the serialized data
     * @throws IOException if serialization fails
     */
    public RoutingCommandNewImpl from(byte[] data) throws IOException {
        return MAPPER.readValue(data, RoutingCommandNewImpl.class);
    }

    /**
     * Serializes an object.
     * 
     * @param source the source object
     * @return the serialized data
     * @throws IOException if serialization fails
     */
    public byte[] to(RoutingCommandNewImpl source) throws IOException {
        return MAPPER.writeValueAsBytes(source);
    }

    /**
     * Creates a cloned copy.
     * 
     * @param origin the original object
     * @return the copied object
     * @throws IOException if cloning fails
     */
    public RoutingCommandNewImpl clone(RoutingCommandNewImpl origin) throws IOException {
        return new RoutingCommandNewImpl(origin);
    }

    /**
     * Returns the handled type.
     * 
     * @return the type
     */
    public Class<RoutingCommandNewImpl> getType() {
        return RoutingCommandNewImpl.class;
    }

}
