/*
 * Decompiled with CFR 0.152.
 */
package test.de.oktoflow.platform.support.logging.slf4j.simple;

import de.iip_ecosphere.platform.support.logging.LogLevel;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.CurrentClassloaderPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.plugins.PluginSetupDescriptor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Slf4jLoggerTest {
    @BeforeClass
    public static void setup() {
        PluginManager.registerPlugin((PluginSetupDescriptor)new CurrentClassloaderPluginSetupDescriptor());
        LoggerFactory.considerPlugin();
    }

    @Test
    public void testFactory() {
        Logger l1;
        Logger l = LoggerFactory.getLogger(this.getClass());
        Assert.assertTrue((l == (l1 = LoggerFactory.getLogger((Object)this)) ? 1 : 0) != 0);
        l1 = LoggerFactory.getLogger(this.getClass());
        Assert.assertTrue((l == l1 ? 1 : 0) != 0);
        l1 = LoggerFactory.getLogger(Slf4jLoggerTest.class);
        Assert.assertTrue((l == l1 ? 1 : 0) != 0);
        l1 = LoggerFactory.getLogger((String)Slf4jLoggerTest.class.getName());
        Assert.assertTrue((l == l1 ? 1 : 0) != 0);
    }

    @Test
    public void testAll() {
        Throwable t = new Throwable("JUST A TEST THROWABLE, DO NOT WORRY");
        Logger l = LoggerFactory.getLogger((Object)this);
        l.setLevel(LogLevel.ALL);
        l.error("ERROR-MSG");
        l.error("ERROR-MSG {}", (Object)1);
        l.error("ERROR-MSG {} {}", (Object)1, (Object)2);
        l.error("ERROR-MSG {} {}, {}", new Object[]{1, 2, null});
        l.error("ERROR-MSG", t);
        l.warn("WARN-MSG");
        l.warn("WARN-MSG {}", (Object)1);
        l.warn("WARN-MSG {} {}", (Object)1, (Object)2);
        l.warn("WARN-MSG {} {}, {}", new Object[]{1, 2, "three"});
        l.warn("WARN-MSG", t);
        l.info("INFO-MSG");
        l.info("INFO-MSG {}", (Object)1);
        l.info("INFO-MSG {} {}", (Object)1, (Object)2);
        l.info("INFO-MSG {} {}, {}", new Object[]{1, 2, "three"});
        l.info("INFO-MSG", t);
        l.debug("INFO-DEBUG");
        l.debug("INFO-DEBUG {}", (Object)1);
        l.debug("INFO-DEBUG {} {}", (Object)1, (Object)2);
        l.debug("INFO-DEBUG {} {}, {}", new Object[]{1, 2, "three"});
        l.debug("INFO-DEBUG", t);
        l.trace("INFO-TRACE");
        l.trace("INFO-TRACE {}", (Object)1);
        l.trace("INFO-TRACE {} {}", (Object)1, (Object)2);
        l.trace("INFO-TRACE {} {}, {}", new Object[]{1, 2, "three"});
        l.trace("INFO-TRACE", t);
    }
}

