/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.logging.slf4j.simple;

import de.iip_ecosphere.platform.support.logging.ILoggerFactory;
import de.iip_ecosphere.platform.support.logging.LogLevel;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactoryDescriptor;
import de.iip_ecosphere.platform.support.plugins.SingletonPluginDescriptor;
import de.oktoflow.platform.support.logging.slf4j.simple.Slf4jLogger;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class Slf4jLoggerFactoryDescriptor
extends SingletonPluginDescriptor<ILoggerFactory>
implements LoggerFactoryDescriptor {
    public Slf4jLoggerFactoryDescriptor() {
        super("log-slf4j-simple", null, ILoggerFactory.class, p -> new Slf4jLoggerFactory());
    }

    public ILoggerFactory create() {
        return new Slf4jLoggerFactory();
    }

    static {
        System.setProperty("log4j2.formatMsgNoLookups", "true");
    }

    private static class Slf4jLoggerFactory
    implements ILoggerFactory {
        private Map<String, LogLevel> initialLevels;

        private Slf4jLoggerFactory() {
        }

        public Logger createLogger(String name) {
            LogLevel initialLevel;
            Slf4jLogger result = new Slf4jLogger(LoggerFactory.getLogger((String)name));
            if (this.initialLevels != null && null != (initialLevel = this.initialLevels.get(name))) {
                result.setLevel(initialLevel);
            }
            return result;
        }

        public void initialLevels(Map<String, LogLevel> levels) {
            this.initialLevels = levels;
        }
    }
}

