/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.logging.slf4j.simple;

import de.iip_ecosphere.platform.support.logging.LogLevel;
import org.slf4j.Logger;

public class Slf4jLogger
implements de.iip_ecosphere.platform.support.logging.Logger {
    private Logger logger;
    private LogLevel level = LogLevel.ALL;

    public Slf4jLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean setLevel(LogLevel level) {
        this.level = level;
        return true;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public String getName() {
        return this.logger.getName();
    }

    private void ifEnabled(LogLevel level, Runnable func) {
        if (level.isEnabled(this.level)) {
            func.run();
        }
    }

    public void trace(String msg) {
        this.ifEnabled(LogLevel.TRACE, () -> this.logger.trace(msg));
    }

    public void trace(String format, Object arg) {
        this.ifEnabled(LogLevel.TRACE, () -> this.logger.trace(format, arg));
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.ifEnabled(LogLevel.TRACE, () -> this.logger.trace(format, arg1, arg2));
    }

    public void trace(String format, Object ... arguments) {
        this.ifEnabled(LogLevel.TRACE, () -> this.logger.trace(format, arguments));
    }

    public void trace(String msg, Throwable th) {
        this.ifEnabled(LogLevel.TRACE, () -> this.logger.trace(msg, th));
    }

    public void debug(String msg) {
        this.ifEnabled(LogLevel.DEBUG, () -> this.logger.debug(msg));
    }

    public void debug(String format, Object arg) {
        this.ifEnabled(LogLevel.DEBUG, () -> this.logger.debug(format, arg));
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.ifEnabled(LogLevel.DEBUG, () -> this.logger.debug(format, arg1, arg2));
    }

    public void debug(String format, Object ... arguments) {
        this.ifEnabled(LogLevel.DEBUG, () -> this.logger.debug(format, arguments));
    }

    public void debug(String msg, Throwable th) {
        this.ifEnabled(LogLevel.DEBUG, () -> this.logger.debug(msg, th));
    }

    public void info(String msg) {
        this.ifEnabled(LogLevel.INFO, () -> this.logger.info(msg));
    }

    public void info(String format, Object arg) {
        this.ifEnabled(LogLevel.INFO, () -> this.logger.info(format, arg));
    }

    public void info(String format, Object arg1, Object arg2) {
        this.ifEnabled(LogLevel.INFO, () -> this.logger.info(format, arg1, arg2));
    }

    public void info(String format, Object ... arguments) {
        this.ifEnabled(LogLevel.INFO, () -> this.logger.info(format, arguments));
    }

    public void info(String msg, Throwable th) {
        this.ifEnabled(LogLevel.INFO, () -> this.logger.info(msg, th));
    }

    public void warn(String msg) {
        this.ifEnabled(LogLevel.WARN, () -> this.logger.warn(msg));
    }

    public void warn(String format, Object arg) {
        this.ifEnabled(LogLevel.WARN, () -> this.logger.warn(format, arg));
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.ifEnabled(LogLevel.WARN, () -> this.logger.warn(format, arg1, arg2));
    }

    public void warn(String format, Object ... arguments) {
        this.ifEnabled(LogLevel.WARN, () -> this.logger.warn(format, arguments));
    }

    public void warn(String msg, Throwable th) {
        this.ifEnabled(LogLevel.WARN, () -> this.logger.warn(msg, th));
    }

    public void error(String msg) {
        this.ifEnabled(LogLevel.ERROR, () -> this.logger.error(msg));
    }

    public void error(String format, Object arg) {
        this.ifEnabled(LogLevel.ERROR, () -> this.logger.error(format, arg));
    }

    public void error(String format, Object arg1, Object arg2) {
        this.ifEnabled(LogLevel.ERROR, () -> this.logger.error(format, arg1, arg2));
    }

    public void error(String format, Object ... arguments) {
        this.ifEnabled(LogLevel.ERROR, () -> this.logger.error(format, arguments));
    }

    public void error(String msg, Throwable th) {
        this.ifEnabled(LogLevel.ERROR, () -> this.logger.error(msg, th));
    }
}

