/*
 * Decompiled with CFR 0.152.
 */
package test.de.oktoflow.platform.support.metrics.micrometer;

import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.metrics.Clock;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Gauge;
import de.iip_ecosphere.platform.support.metrics.Measurement;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.support.metrics.MeterFilter;
import de.iip_ecosphere.platform.support.metrics.MetricsFactory;
import de.iip_ecosphere.platform.support.metrics.Tag;
import de.iip_ecosphere.platform.support.metrics.Timer;
import de.oktoflow.platform.support.metrics.micrometer.MicrometerMetricsFactory;
import de.oktoflow.platform.support.metrics.micrometer.MicrometerUtils;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class MicrometerTest {
    @Test
    public void testMetrics() throws IOException {
        MetricsFactory fac = MetricsFactory.getInstance();
        Assert.assertTrue((boolean)(fac instanceof MicrometerMetricsFactory));
        de.iip_ecosphere.platform.support.metrics.MeterRegistry reg = fac.createRegistry();
        Assert.assertNotNull((Object)reg);
        Counter counter = (Counter)((Counter.CounterBuilder)((Counter.CounterBuilder)MetricsFactory.buildCounter((String)"myCounter").baseUnit("bit/s").description("myDesc")).tags(new String[]{"t1", "vt1"})).register(reg);
        counter.increment(2.0);
        Assert.assertTrue((counter.count() > 1.0 ? 1 : 0) != 0);
        AtomicInteger gVal = new AtomicInteger(5);
        Gauge gauge = (Gauge)((Gauge.GaugeBuilder)((Gauge.GaugeBuilder)MetricsFactory.buildGauge((String)"myGauge", (Object)gVal, v -> v.doubleValue()).description("myDescG")).baseUnit("parts/s").tags(new String[]{"t1", "vg1"})).register(reg);
        Assert.assertEquals((long)gVal.get(), (long)((int)gauge.value()));
        gVal.incrementAndGet();
        Gauge gauge2 = (Gauge)((Gauge.GaugeBuilder)((Gauge.GaugeBuilder)MetricsFactory.buildGauge((String)"myGauge2", () -> gVal.doubleValue()).description("myDescG")).baseUnit("parts/s").tags(new String[]{"t1", "vg2"})).register(reg);
        Assert.assertEquals((long)gVal.get(), (long)((int)gauge2.value()));
        this.assertId((Meter)gauge2);
        Timer timer = (Timer)((Timer.TimerBuilder)((Timer.TimerBuilder)MetricsFactory.buildTimer((String)"myTimer").description("myDescT")).tags(new String[]{"t1", "vt1"})).register(reg);
        this.assertId((Meter)timer);
        this.testTimerRecord(timer);
        Assert.assertTrue((timer.count() >= 5L ? 1 : 0) != 0);
        Assert.assertTrue((timer.max(TimeUnit.MILLISECONDS) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((timer.mean(TimeUnit.MILLISECONDS) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((timer.totalTime(TimeUnit.MILLISECONDS) > 600.0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((Object)timer.baseTimeUnit()));
        reg.config().meterFilter(MetricsFactory.denyNameStartsWith((String)"java."));
        Assert.assertNotNull((Object)reg.config().clock());
        Assert.assertEquals((Object)gauge2, (Object)reg.getMeter(gauge2.getName()));
        Assert.assertEquals((Object)gauge2, (Object)reg.getMeter(gauge2.getName(), List.of(fac.createTag("t1", "vg2"))));
        Assert.assertEquals((Object)gauge, (Object)reg.getGauge(gauge.getName()));
        Assert.assertEquals((Object)timer, (Object)reg.getTimer(timer.getName()));
        Assert.assertEquals((Object)counter, (Object)reg.getCounter(counter.getName()));
        Assert.assertNull((Object)reg.getTimer(counter.getName()));
        Assert.assertNull((Object)reg.getTimer("abc"));
        Assert.assertNull((Object)reg.getMeter("abcd"));
        Assert.assertNull((Object)reg.remove("abcd"));
        Assert.assertEquals((Object)gauge2, (Object)reg.remove((Meter)gauge2));
        Assert.assertNull((Object)reg.getMeter(gauge2.getName()));
        Assert.assertNull((Object)reg.remove((Meter)gauge2));
        Clock clock = reg.config().clock();
        Assert.assertNotNull((Object)clock);
        Assert.assertTrue((clock.monotonicTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((clock.wallTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)clock.equals((Object)clock));
        Assert.assertFalse((boolean)clock.equals((Object)reg));
        clock.hashCode();
        Assert.assertNotNull((Object)reg.getMeters());
        int size = reg.getMeters().size();
        Assert.assertTrue((size >= 3 ? 1 : 0) != 0);
        reg.config().meterFilter(MetricsFactory.denyNameStartsWith((String)"xxx"));
        MetricsFactory.buildTimer((String)"xxx").register(reg);
        Assert.assertTrue((reg.getMeters().size() == size ? 1 : 0) != 0);
    }

    @Test
    public void testMetrics2() {
        MetricsFactory fac = MetricsFactory.getInstance();
        de.iip_ecosphere.platform.support.metrics.MeterRegistry reg = fac.createRegistry();
        Counter c1 = reg.counter("c1", new String[]{"instance", "c1"});
        Counter c2 = reg.counter("c1", new String[]{"instance", "c2"});
        reg.remove(c2.getId());
        Tag ic1 = fac.createImmutableTag("instance", "c1");
        Assert.assertEquals((Object)"instance", (Object)ic1.getKey());
        Assert.assertEquals((Object)"c1", (Object)ic1.getValue());
        ic1.hashCode();
        Assert.assertTrue((boolean)ic1.equals((Object)ic1));
        Tag ic11 = fac.createImmutableTag("instance", "c1");
        Assert.assertTrue((boolean)ic1.equals((Object)ic11));
        Assert.assertFalse((boolean)ic1.equals((Object)reg));
        Meter m = reg.getMeter("c1", List.of(ic1, fac.createImmutableTag("instance", "c1")));
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)c1, (Object)m);
        Assert.assertNull((Object)reg.getMeter("c1", List.of(fac.createImmutableTag("a", "b"))));
        Assert.assertNull((Object)reg.remove(c2.getId()));
        Timer t1 = reg.timer("t1", new String[]{"instance", "t1"});
        Assert.assertEquals((Object)"t1", (Object)t1.getName());
        Assert.assertEquals((double)12.3, (double)((Double)reg.gauge("g1", (Number)12.3)), (double)0.1);
        MeterFilter f = fac.createFilterDeny();
        Assert.assertNotNull((Object)f.accept(fac.createId("id", null, null, null, null)));
        Assert.assertNotNull((Object)f.accept(fac.createId("id", List.of(ic1), "m/s", "desc", Meter.Type.COUNTER)));
        fac.createFilterAcceptNameStartsWith("i");
        Measurement me = fac.createMeasurement(() -> 2.0, de.iip_ecosphere.platform.support.metrics.Statistic.VALUE);
        Assert.assertEquals((double)2.0, (double)me.getValue(), (double)0.01);
        Assert.assertEquals((Object)de.iip_ecosphere.platform.support.metrics.Statistic.VALUE, (Object)me.getStatistic());
        Assert.assertEquals((Object)de.iip_ecosphere.platform.support.metrics.Statistic.VALUE.name(), (Object)me.getStatisticAsString());
        fac.createTimerStart().stop(t1);
    }

    @Test
    public void testCreateRegistry() {
        MetricsFactory fac = MetricsFactory.getInstance();
        de.iip_ecosphere.platform.support.metrics.MeterRegistry reg = fac.createRegistry((Object)new SimpleMeterRegistry());
        Assert.assertNotNull((Object)reg);
        reg = fac.createRegistry(new Object());
        Assert.assertNotNull((Object)reg);
    }

    private void testTimerRecord(Timer timer) {
        timer.record(() -> TimeUtils.sleep((int)500));
        Assert.assertEquals((long)5L, (long)((Integer)timer.record(() -> 5)).intValue());
        timer.record(100L, TimeUnit.MILLISECONDS);
        try {
            Assert.assertEquals((long)1L, (long)((Integer)timer.recordCallable(() -> {
                TimeUtils.sleep((int)100);
                return 1;
            })).intValue());
        }
        catch (Exception e) {
            Assert.fail((String)"No exception expected");
        }
        try {
            Assert.assertEquals((long)1L, (long)((Integer)timer.recordCallable(() -> {
                throw new Exception();
            })).intValue());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            // empty catch block
        }
        List measures = CollectionUtils.toList((Iterable)timer.measure());
        Assert.assertTrue((measures.size() > 0 ? 1 : 0) != 0);
        for (Measurement m : measures) {
            Assert.assertNotNull((Object)m.getStatistic());
            Assert.assertNotNull((Object)m.getStatisticAsString());
            Assert.assertNotNull((Object)(m.getValue() >= 0.0 ? 1 : 0));
            m.hashCode();
            Assert.assertTrue((boolean)m.equals((Object)m));
            Assert.assertFalse((boolean)m.equals((Object)measures));
        }
    }

    private void assertId(Meter meter) {
        Meter.Id id = meter.getId();
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((Object)meter.getName(), (Object)id.getName());
        id.getBaseUnit();
        id.getDescription();
        Assert.assertNull((Object)id.getTag("yxz"));
        id.getTags();
        id.getTagsAsIterable();
        Assert.assertNotNull((Object)id.getType());
        Assert.assertTrue((boolean)id.equals((Object)id));
        Assert.assertFalse((boolean)id.equals((Object)meter));
        id.hashCode();
        Assert.assertTrue((boolean)meter.equals((Object)meter));
        Assert.assertFalse((boolean)meter.equals((Object)id));
        meter.hashCode();
        Assert.assertNotNull((Object)id.toString());
    }

    @Test
    public void testUtils() {
        MetricsFactory fac = MetricsFactory.getInstance();
        de.iip_ecosphere.platform.support.metrics.MeterRegistry reg = fac.createRegistry();
        List<Tag> tags = List.of(fac.createImmutableTag("i", "c1"), fac.createImmutableTag("i", "c2"));
        List tags2 = CollectionUtils.toList((Iterable)MicrometerUtils.mmWrapTagIterable((Iterable)MicrometerUtils.wrapTagIterable(tags)));
        Assert.assertEquals(tags, (Object)tags2);
        List<Measurement> meas = List.of(fac.createMeasurement(() -> 1.0, de.iip_ecosphere.platform.support.metrics.Statistic.VALUE), fac.createMeasurement(() -> 2.0, de.iip_ecosphere.platform.support.metrics.Statistic.VALUE));
        List meas2 = CollectionUtils.toList((Iterable)MicrometerUtils.mmWrapMeasurementIterable((Iterable)MicrometerUtils.wrapMeasurementIterable(meas)));
        Assert.assertEquals(meas, (Object)meas2);
        MeterFilter filter = MetricsFactory.deny();
        MeterFilter filter2 = MicrometerUtils.mmFilterValue((io.micrometer.core.instrument.config.MeterFilter)MicrometerUtils.filterValue((MeterFilter)filter));
        Assert.assertEquals((Object)filter, (Object)filter2);
        filter.hashCode();
        Object[] fi = new MeterFilter[]{filter, MetricsFactory.acceptNameStartsWith((String)"x")};
        Object[] fi2 = MicrometerUtils.mmFilterValue((io.micrometer.core.instrument.config.MeterFilter[])MicrometerUtils.filterValue((MeterFilter[])fi));
        Assert.assertArrayEquals((Object[])fi, (Object[])fi2);
        Counter counter = (Counter)MetricsFactory.buildCounter((String)"counter").register(reg);
        counter.increment();
        Assert.assertNull((Object)MicrometerUtils.createMeter((Meter)counter, (id, type, mea) -> {
            Assert.assertEquals((Object)"counter", (Object)id.getName());
            Assert.assertEquals((Object)Meter.Type.COUNTER, (Object)type);
            Assert.assertTrue((CollectionUtils.toList(mea.iterator()).size() == 1 ? 1 : 0) != 0);
            return null;
        }));
        Assert.assertNull((Object)MicrometerUtils.createMeter(null, (i, t, m) -> null));
        Assert.assertEquals((Object)de.iip_ecosphere.platform.support.metrics.Statistic.VALUE, (Object)MicrometerUtils.value(de.iip_ecosphere.platform.support.metrics.Statistic.class, (Enum)Statistic.VALUE, (Enum)de.iip_ecosphere.platform.support.metrics.Statistic.UNKNOWN));
        Assert.assertEquals((Object)de.iip_ecosphere.platform.support.metrics.Statistic.VALUE, (Object)MicrometerUtils.value(de.iip_ecosphere.platform.support.metrics.Statistic.class, (String)null, (Enum)de.iip_ecosphere.platform.support.metrics.Statistic.VALUE));
        Assert.assertEquals((Object)de.iip_ecosphere.platform.support.metrics.Statistic.VALUE, (Object)MicrometerUtils.value(de.iip_ecosphere.platform.support.metrics.Statistic.class, (String)"1xyz", (Enum)de.iip_ecosphere.platform.support.metrics.Statistic.VALUE));
        Assert.assertNull((Object)MicrometerUtils.filterValue((MeterFilter)null));
        Assert.assertNull((Object)MicrometerUtils.idValue((Meter.Id)null));
        Assert.assertNull((Object)MicrometerUtils.tagValue((Tag)null));
        Assert.assertEquals((Object)Statistic.UNKNOWN, (Object)MicrometerUtils.statisticValue((de.iip_ecosphere.platform.support.metrics.Statistic)null));
    }

    @Test
    public void testUtilsMM() {
        io.micrometer.core.instrument.config.MeterFilter[] filter = new io.micrometer.core.instrument.config.MeterFilter[]{io.micrometer.core.instrument.config.MeterFilter.acceptNameStartsWith((String)"y")};
        io.micrometer.core.instrument.config.MeterFilter[] filter2 = MicrometerUtils.append((io.micrometer.core.instrument.config.MeterFilter[])filter, (io.micrometer.core.instrument.config.MeterFilter[])new io.micrometer.core.instrument.config.MeterFilter[]{io.micrometer.core.instrument.config.MeterFilter.accept(), io.micrometer.core.instrument.config.MeterFilter.deny()});
        Assert.assertTrue((filter2.length == 3 ? 1 : 0) != 0);
        Meter.Id id = new Meter.Id("y", null, null, null, null);
        Assert.assertTrue((boolean)MicrometerUtils.include((Meter.Id)id, (io.micrometer.core.instrument.config.MeterFilter[])filter));
        Assert.assertFalse((boolean)MicrometerUtils.include((Meter.Id)id, (io.micrometer.core.instrument.config.MeterFilter[])new io.micrometer.core.instrument.config.MeterFilter[]{io.micrometer.core.instrument.config.MeterFilter.deny()}));
        Assert.assertTrue((boolean)MicrometerUtils.include((String)"y", (io.micrometer.core.instrument.config.MeterFilter[])filter));
        Assert.assertFalse((boolean)MicrometerUtils.include((String)"y", (io.micrometer.core.instrument.config.MeterFilter[])new io.micrometer.core.instrument.config.MeterFilter[]{io.micrometer.core.instrument.config.MeterFilter.deny()}));
        Assert.assertTrue((boolean)MicrometerUtils.include((String)"y", (io.micrometer.core.instrument.config.MeterFilter[])new io.micrometer.core.instrument.config.MeterFilter[]{io.micrometer.core.instrument.config.MeterFilter.accept()}));
        Assert.assertTrue((boolean)MicrometerUtils.include((String)"y", (io.micrometer.core.instrument.config.MeterFilter[])new io.micrometer.core.instrument.config.MeterFilter[]{io.micrometer.core.instrument.config.MeterFilter.acceptNameStartsWith((String)"y")}));
        Assert.assertTrue((boolean)MicrometerUtils.include((String)"y", (io.micrometer.core.instrument.config.MeterFilter[])new io.micrometer.core.instrument.config.MeterFilter[]{io.micrometer.core.instrument.config.MeterFilter.acceptNameStartsWith((String)"y"), io.micrometer.core.instrument.config.MeterFilter.accept()}));
        SimpleMeterRegistry reg = new SimpleMeterRegistry();
        MicrometerUtils.apply((MeterRegistry)reg, (io.micrometer.core.instrument.config.MeterFilter[])filter2);
        Assert.assertEquals((Object)de.iip_ecosphere.platform.support.metrics.Statistic.UNKNOWN, (Object)MicrometerUtils.mmStatisticValue((Statistic)null));
        Assert.assertEquals((Object)de.iip_ecosphere.platform.support.metrics.Statistic.ACTIVE_TASKS, (Object)MicrometerUtils.mmStatisticValue((Statistic)Statistic.ACTIVE_TASKS));
    }
}

