/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.aas.RbacRoles;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.lang.ref.WeakReference;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public interface AuthenticationDescriptor {
    public IdentityToken getClientToken();

    public static boolean isEnabledOnClient(AuthenticationDescriptor desc) {
        return null != desc && desc.getClientToken() != null;
    }

    public static boolean isEnabledOnServer(AuthenticationDescriptor desc) {
        return null != desc && (desc.getServerUsers() != null || desc.getOAuth2Setup() != null);
    }

    public List<IdentityTokenWithRole> getServerUsers();

    public void enableRbac();

    public void addAccessRule(RbacRule var1);

    public List<RbacRule> getAccessRules();

    default public boolean requiresAnonymousAccess() {
        boolean result = false;
        List<RbacRule> rules = this.getAccessRules();
        if (null != rules) {
            result = rules.stream().anyMatch(u -> DefaultRole.NONE == u.getRole());
        }
        return result;
    }

    public static void addAccessRule(AuthenticationDescriptor desc, RbacRule rule) {
        if (null != desc && null != rule) {
            desc.addAccessRule(rule);
        }
    }

    public static <T> T aasRbac(T caller, AuthenticationDescriptor auth, Role role, String idShort, RbacAction ... actions) {
        if (null != auth) {
            auth.addAccessRule(new RbacRule(RbacAasComponent.AAS, role, idShort, null, actions).creator(caller));
        }
        return caller;
    }

    public static <T> T submodelRbac(T caller, AuthenticationDescriptor auth, Role role, String idShort, RbacAction ... actions) {
        if (null != auth) {
            auth.addAccessRule(new RbacRule(RbacAasComponent.SUBMODEL, role, idShort, "*", actions).creator(caller));
        }
        return caller;
    }

    public static <T> T elementRbac(T caller, AuthenticationDescriptor auth, Role role, String path, RbacAction ... actions) {
        int pos;
        if (null != auth && StringUtils.isNotBlank((CharSequence)path) && null != role && null != actions && (pos = path.indexOf(".")) > 0) {
            String smId = path.substring(0, pos);
            String pth = path.substring(pos + 1);
            auth.addAccessRule(new RbacRule(RbacAasComponent.SUBMODEL_ELEMENT, role, smId, pth, actions).creator(caller));
        }
        return caller;
    }

    public static <T> T parentRbac(T caller, AuthenticationDescriptor auth, Object[] parents, String path, RbacAction ... minActions) {
        List<RbacRule> rules;
        if (null != auth && parents != null && path != null && path.length() > 0 && !(rules = auth.getAccessRules()).stream().anyMatch(r -> r.isCreator(caller))) {
            String pth;
            String smId;
            HashSet roles = new HashSet();
            HashSet<RbacAction> actions = new HashSet<RbacAction>();
            for (RbacAction a : minActions) {
                actions.add(a);
            }
            rules.stream().filter(r -> r.isCreator(parents)).forEach(r -> {
                roles.add(r.getRole());
                actions.addAll(r.actions);
            });
            int pos = path.indexOf(".");
            if (pos > 0) {
                smId = path.substring(0, pos);
                pth = path.substring(pos + 1);
            } else {
                smId = path;
                pth = null;
            }
            RbacAction[] act = actions.toArray(new RbacAction[actions.size()]);
            for (Role r2 : roles) {
                auth.addAccessRule(new RbacRule(RbacAasComponent.SUBMODEL_ELEMENT, r2, smId, pth, act).creator(caller));
            }
        }
        return caller;
    }

    public static boolean definesRbac(AuthenticationDescriptor desc) {
        return AuthenticationDescriptor.isEnabledOnServer(desc) && desc.getAccessRules() != null;
    }

    public OAuth2Setup getOAuth2Setup();

    public static String authenticate(AuthenticationDescriptor aDesc, boolean prependHeaderFieldName) {
        StringBuffer buf = new StringBuffer();
        AuthenticationDescriptor.authenticate((String n, String v) -> {
            if (prependHeaderFieldName) {
                buf.append(n);
                buf.append(":");
            }
            buf.append(v);
        }, aDesc);
        return buf.isEmpty() ? null : buf.toString();
    }

    public static void authenticate(HeaderValueConsumer consumer, AuthenticationDescriptor aDesc) {
        IdentityToken clientToken;
        if (aDesc != null && (clientToken = aDesc.getClientToken()) != null) {
            switch (clientToken.getType()) {
                case USERNAME: {
                    String credentials = clientToken.getUserName() + ":" + clientToken.getTokenDataAsString();
                    String headerValue = "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes());
                    consumer.consume("Authorization", headerValue);
                    break;
                }
                case ISSUED: {
                    consumer.consume("Authorization", "Bearer " + clientToken.getTokenDataAsString());
                    break;
                }
                case ANONYMOUS: {
                    break;
                }
                default: {
                    LoggerFactory.getLogger(AuthenticationDescriptor.class).error("Authentication token type {} not supported for setting up HTTP authentication. Staying unauthenticated.", (Object)clientToken.getType());
                }
            }
        }
    }

    public static interface OAuth2Setup {
        public String getIssuerUri();

        public String getJwkSetUri();

        public String getRequiredAud();
    }

    public static class RbacRule {
        public static final String PATH_SEPARATOR = ".";
        private RbacAasComponent component;
        private List<RbacAction> actions;
        private Role role;
        private String element;
        private WeakReference<Object> creator;
        private String path;

        public RbacRule(RbacAasComponent component, Role role, String element, String path, RbacAction ... actions) {
            this.component = component;
            this.role = role;
            this.element = element;
            this.path = path;
            this.actions = Collections.unmodifiableList(CollectionUtils.toList((Object[])actions));
        }

        public RbacAasComponent getComponent() {
            return this.component;
        }

        public List<RbacAction> getActions() {
            return this.actions;
        }

        public Role getRole() {
            return this.role;
        }

        public String getElement() {
            return this.element;
        }

        public String getPath() {
            return this.path;
        }

        public Object getCreator() {
            return null != this.creator ? this.creator.get() : null;
        }

        public RbacRule creator(Object creator) {
            this.creator = null != creator ? new WeakReference<Object>(creator) : null;
            return this;
        }

        public boolean isCreator(Object object) {
            Object cr = this.getCreator();
            return null != cr && (cr == object || cr.equals(object));
        }

        public boolean isCreator(Object[] objects) {
            boolean found = false;
            for (int o = 0; !found && o < objects.length; ++o) {
                found = this.isCreator(objects[o]);
            }
            return found;
        }

        public String toString() {
            return "RbacRule{" + "component='" + (Object)((Object)this.component) + "', role='" + this.role + "', actions='" + this.actions + "', element='" + this.element + "', path='" + this.path + "'}";
        }
    }

    public static enum RbacAasComponent {
        AAS,
        SUBMODEL,
        SUBMODEL_ELEMENT;

    }

    public static interface Role {
        public String name();

        public boolean anonymous();

        public static Role[] allAuthenticated() {
            return RbacRoles.allAuthenticated();
        }

        public static Role[] allExcept(boolean authenticated, Role ... except) {
            return RbacRoles.allExcept(authenticated, except);
        }

        public static Role[] of(Role ... roles) {
            return roles;
        }

        public static Role[] allAnonymous() {
            return RbacRoles.allAnonymous();
        }

        public static Role[] all() {
            return RbacRoles.all();
        }
    }

    public static enum RbacAction {
        READ,
        CREATE,
        UPDATE,
        EXECUTE,
        DELETE;


        public static RbacAction[] all() {
            return RbacAction.values();
        }

        public static RbacAction[] of(RbacAction ... actions) {
            return actions;
        }
    }

    public static interface HeaderValueConsumer {
        public void consume(String var1, String var2);
    }

    public static enum DefaultRole implements Role
    {
        USER(false),
        PLATFORM(false),
        DEVICE(false),
        ADMIN(false),
        NONE(true);

        private boolean anonymous;

        private DefaultRole(boolean anonymous) {
            this.anonymous = anonymous;
        }

        @Override
        public boolean anonymous() {
            return this.anonymous;
        }
    }

    public static class DefaultOAuth2Setup
    implements OAuth2Setup {
        private String issuerUri;
        private String jwkSetUri;
        private String requiredAud;

        public DefaultOAuth2Setup(String issuerUri, String jwkSetUri, String requiredAud) {
            this.issuerUri = issuerUri;
            this.jwkSetUri = jwkSetUri;
            this.requiredAud = requiredAud;
        }

        @Override
        public String getIssuerUri() {
            return this.issuerUri;
        }

        @Override
        public String getJwkSetUri() {
            return this.jwkSetUri;
        }

        @Override
        public String getRequiredAud() {
            return this.requiredAud;
        }
    }

    public static class IdentityTokenWithRole
    extends IdentityToken {
        private Role role;

        protected IdentityTokenWithRole(IdentityToken token, Role role) {
            super(token);
            this.role = role;
        }

        public Role getRole() {
            return this.role;
        }

        @Override
        public String toString() {
            return super.toString() + " as " + String.valueOf(this.role);
        }
    }
}

