/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.net;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class UriResolver {
    public static File resolveToFile(URI uri, File dir) throws IOException {
        File result = null;
        if ("file".equals(uri.getScheme())) {
            result = new File(uri);
        } else {
            URL url = uri.toURL();
            File f = null;
            try (InputStream in = url.openStream();){
                Object path = uri.getPath();
                int pos = ((String)path).lastIndexOf("/");
                if (pos > 0 && pos < ((String)path).length() - 1) {
                    path = ((String)path).substring(pos + 1);
                }
                pos = ((String)path).lastIndexOf(".");
                String suffix = "";
                if (pos > 0) {
                    suffix = ((String)path).substring(pos);
                    path = ((String)path).substring(0, pos);
                }
                if (null == dir) {
                    f = File.createTempFile("iip", suffix);
                } else {
                    path = (String)path + "-" + System.currentTimeMillis() + suffix;
                    f = new File(dir, (String)path);
                }
                Files.copy(in, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            result = f;
        }
        return result;
    }
}

