/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.certprovider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.InternalLogId;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.TimeProvider;
import io.grpc.xds.internal.certprovider.CertificateProvider;
import io.grpc.xds.internal.sds.trust.CertificateUtils;
import java.io.ByteArrayInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FileWatcherCertificateProvider
extends CertificateProvider {
    private static final Logger logger = Logger.getLogger(FileWatcherCertificateProvider.class.getName());
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService scheduledExecutorService;
    private final TimeProvider timeProvider;
    private final Path certFile;
    private final Path keyFile;
    private final Path trustFile;
    private final long refreshIntervalInSeconds;
    @VisibleForTesting
    SynchronizationContext.ScheduledHandle scheduledHandle;
    private FileTime lastModifiedTimeCert;
    private FileTime lastModifiedTimeKey;
    private FileTime lastModifiedTimeRoot;

    FileWatcherCertificateProvider(CertificateProvider.DistributorWatcher watcher, boolean notifyCertUpdates, String certFile, String keyFile, String trustFile, long refreshIntervalInSeconds, ScheduledExecutorService scheduledExecutorService, TimeProvider timeProvider) {
        super(watcher, notifyCertUpdates);
        this.scheduledExecutorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"scheduledExecutorService");
        this.timeProvider = (TimeProvider)Preconditions.checkNotNull((Object)timeProvider, (Object)"timeProvider");
        this.certFile = Paths.get((String)Preconditions.checkNotNull((Object)certFile, (Object)"certFile"), new String[0]);
        this.keyFile = Paths.get((String)Preconditions.checkNotNull((Object)keyFile, (Object)"keyFile"), new String[0]);
        this.trustFile = Paths.get((String)Preconditions.checkNotNull((Object)trustFile, (Object)"trustFile"), new String[0]);
        this.refreshIntervalInSeconds = refreshIntervalInSeconds;
        this.syncContext = this.createSynchronizationContext(certFile);
    }

    private SynchronizationContext createSynchronizationContext(String details) {
        final InternalLogId logId = InternalLogId.allocate((String)"DynamicReloadingCertificateProvider", (String)details);
        return new SynchronizationContext(new Thread.UncaughtExceptionHandler(){
            private boolean panicMode;

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.log(Level.SEVERE, "[" + logId + "] Uncaught exception in the SynchronizationContext. Panic!", e);
                this.panic(e);
            }

            void panic(Throwable t) {
                if (this.panicMode) {
                    return;
                }
                this.panicMode = true;
                FileWatcherCertificateProvider.this.close();
            }
        });
    }

    @Override
    public void start() {
        this.scheduleNextRefreshCertificate(0L);
    }

    @Override
    public void close() {
        if (this.scheduledHandle != null) {
            this.scheduledHandle.cancel();
            this.scheduledHandle = null;
        }
        this.getWatcher().close();
    }

    private void scheduleNextRefreshCertificate(long delayInSeconds) {
        RefreshCertificateTask runnable = new RefreshCertificateTask();
        this.scheduledHandle = this.syncContext.schedule((Runnable)runnable, delayInSeconds, TimeUnit.SECONDS, this.scheduledExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    void checkAndReloadCertificates() {
        try {
            byte[] rootFileContents;
            FileTime currentRootTime;
            block31: {
                block30: {
                    block33: {
                        FileTime currentCertTime = Files.getLastModifiedTime(this.certFile, new LinkOption[0]);
                        FileTime currentKeyTime = Files.getLastModifiedTime(this.keyFile, new LinkOption[0]);
                        if (currentCertTime.equals(this.lastModifiedTimeCert) || currentKeyTime.equals(this.lastModifiedTimeKey)) break block33;
                        byte[] certFileContents = Files.readAllBytes(this.certFile);
                        byte[] keyFileContents = Files.readAllBytes(this.keyFile);
                        FileTime currentCertTime2 = Files.getLastModifiedTime(this.certFile, new LinkOption[0]);
                        FileTime currentKeyTime2 = Files.getLastModifiedTime(this.keyFile, new LinkOption[0]);
                        if (!currentCertTime2.equals(currentCertTime)) {
                            this.scheduleNextRefreshCertificate(this.refreshIntervalInSeconds);
                            return;
                        }
                        if (!currentKeyTime2.equals(currentKeyTime)) {
                            this.scheduleNextRefreshCertificate(this.refreshIntervalInSeconds);
                            return;
                        }
                        try {
                            try (ByteArrayInputStream certStream = new ByteArrayInputStream(certFileContents);
                                 ByteArrayInputStream keyStream = new ByteArrayInputStream(keyFileContents);){
                                PrivateKey privateKey = CertificateUtils.getPrivateKey(keyStream);
                                X509Certificate[] certs = CertificateUtils.toX509Certificates(certStream);
                                this.getWatcher().updateCertificate(privateKey, Arrays.asList(certs));
                            }
                            this.lastModifiedTimeCert = currentCertTime;
                            this.lastModifiedTimeKey = currentKeyTime;
                        }
                        catch (Throwable t) {
                            this.generateErrorIfCurrentCertExpired(t);
                        }
                    }
                    currentRootTime = Files.getLastModifiedTime(this.trustFile, new LinkOption[0]);
                    if (!currentRootTime.equals(this.lastModifiedTimeRoot)) break block30;
                    this.scheduleNextRefreshCertificate(this.refreshIntervalInSeconds);
                    return;
                    {
                        catch (Throwable t) {
                            this.getWatcher().onError(Status.fromThrowable((Throwable)t));
                            return;
                        }
                    }
                }
                rootFileContents = Files.readAllBytes(this.trustFile);
                FileTime currentRootTime2 = Files.getLastModifiedTime(this.trustFile, new LinkOption[0]);
                if (currentRootTime2.equals(currentRootTime)) break block31;
                this.scheduleNextRefreshCertificate(this.refreshIntervalInSeconds);
                return;
            }
            try (ByteArrayInputStream rootStream = new ByteArrayInputStream(rootFileContents);){
                X509Certificate[] caCerts = CertificateUtils.toX509Certificates(rootStream);
                this.getWatcher().updateTrustedRoots(Arrays.asList(caCerts));
            }
            this.lastModifiedTimeRoot = currentRootTime;
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.scheduleNextRefreshCertificate(this.refreshIntervalInSeconds);
        }
    }

    private void generateErrorIfCurrentCertExpired(Throwable t) {
        X509Certificate currentCert = this.getWatcher().getLastIdentityCert();
        if (currentCert != null) {
            long delaySeconds = this.computeDelaySecondsToCertExpiry(currentCert);
            if (delaySeconds > this.refreshIntervalInSeconds) {
                logger.log(Level.FINER, "reload certificate error", t);
                return;
            }
            this.getWatcher().clearValues();
        }
        this.getWatcher().onError(Status.fromThrowable((Throwable)t));
    }

    private long computeDelaySecondsToCertExpiry(X509Certificate lastCert) {
        Preconditions.checkNotNull((Object)lastCert, (Object)"lastCert");
        return TimeUnit.NANOSECONDS.toSeconds(TimeUnit.MILLISECONDS.toNanos(lastCert.getNotAfter().getTime()) - this.timeProvider.currentTimeNanos());
    }

    static abstract class Factory {
        private static final Factory DEFAULT_INSTANCE = new Factory(){

            @Override
            FileWatcherCertificateProvider create(CertificateProvider.DistributorWatcher watcher, boolean notifyCertUpdates, String certFile, String keyFile, String trustFile, long refreshIntervalInSeconds, ScheduledExecutorService scheduledExecutorService, TimeProvider timeProvider) {
                return new FileWatcherCertificateProvider(watcher, notifyCertUpdates, certFile, keyFile, trustFile, refreshIntervalInSeconds, scheduledExecutorService, timeProvider);
            }
        };

        Factory() {
        }

        static Factory getInstance() {
            return DEFAULT_INSTANCE;
        }

        abstract FileWatcherCertificateProvider create(CertificateProvider.DistributorWatcher var1, boolean var2, String var3, String var4, String var5, long var6, ScheduledExecutorService var8, TimeProvider var9);
    }

    @VisibleForTesting
    class RefreshCertificateTask
    implements Runnable {
        RefreshCertificateTask() {
        }

        @Override
        public void run() {
            FileWatcherCertificateProvider.this.checkAndReloadCertificates();
        }
    }
}

